<?php

/**

 * About Page Template - Fully Optimized for Performance

 */



// Include header (which loads config.php)

include(BASE_PATH . '/app/Views/components/header.php');

?>



<!-- Optimized for minimal LCP and render blocking -->

<div class="container">

    <div class="row">

        <div class="col-lg-8 col-md-10 mx-auto">

            <!-- Above-the-fold content with inline styles -->

            <div style="min-height:300px;padding-top:20px;"> <!-- Generous height reservation for all above-fold content -->

                <!-- First priority content -->

                <h1 style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:2.5rem;font-weight:500;line-height:1.2;text-align:center;margin:20px auto 24px;padding:0;color:#212529;max-width:100%;display:block;border:none;background:none;">About SoberList</h1>

                

                <p id="lcp-element" style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:1.25rem;font-weight:400;line-height:1.5;text-align:center;margin:0 auto 2rem;max-width:800px;color:#212529;">

                    SoberList is building the nation's most comprehensive and accessible recovery resource network.

                </p>

            </div>

            

            <!-- Below-the-fold content - no need for inline optimization -->

            <div>

			

			

			  <!-- Our Founder -->

                <div class="get-involved mt-5 mb-5">

                    <h2 class="text-center mb-4">Who runs Sober List</h2>

				

                    <p>This site was created by Chris Nesbitt, a Firefighter and EMT form NH who realized there were limited online resources available when trying to help family and friends who struggle with addiction and recovery.</p>

					<br>

							

					<p>After entering the emergency medical field, Chris also saw the need to connect people with mental health care resources near them, and decided to create this directory site with purpose of making it the nations largest and most useful website for finding recovery and mental health help.</p>

					<br>

					

						<div style="margin-left:auto; margin-right:auto; text-align:center;"><img src="https://www.soberlist.org/assets/images/ChrisNesbitt.png" alt="Our Founder" /></div>

						

						<br>

						<hr>

				

                </div>

				

				

				

				

                <!-- Our Mission Section -->

                <div class="about-mission mt-5">

                    <h2 class="text-center mb-4">Our Mission</h2>

                    <p>Our mission is to make recovery resources more accessible to everyone who needs them. We believe that finding help should be simple, and that everyone deserves access to quality care and support on their recovery journey.</p>

                    

                    <p>Through our comprehensive directory, we aim to:</p>

                    <ul>

                        <li>Connect individuals with verified recovery resources</li>

                        <li>Provide accurate, up-to-date information about facilities and services</li>

                        <li>Reduce barriers to finding help</li>

                        <li>Support the recovery community nationwide</li>

                    </ul>

                </div>

                

                <!-- Our Vision Section -->

                <div class="about-vision mt-5">

                    <h2 class="text-center mb-4">Our Vision</h2>

                    <p>We envision a future where:</p>

                    <ul>

                        <li>Anyone can quickly find the recovery resources they need, when they need them</li>

                        <li>Recovery resources are easily accessible regardless of location or circumstance</li>

                        <li>Communities are empowered with information and tools to support recovery</li>

                        <li>The stigma surrounding addiction and mental health is reduced through education and awareness</li>

                    </ul>

                </div>

                

                <!-- Our Values Section -->

                <div class="about-values mt-5">

                    <h2 class="text-center mb-4">Our Values</h2>

                    <div class="row mt-4">

                        <div class="col-md-4 mb-4">

                            <div class="value-card p-4 bg-light rounded">

                                <h3>Accessibility</h3>

                                <p>We believe recovery resources should be easily accessible to anyone who needs them, regardless of their location or circumstances.</p>

                            </div>

                        </div>

                        <div class="col-md-4 mb-4">

                            <div class="value-card p-4 bg-light rounded">

                                <h3>Integrity</h3>

                                <p>We are committed to providing accurate, trustworthy information about recovery resources and services.</p>

                            </div>

                        </div>

                        <div class="col-md-4 mb-4">

                            <div class="value-card p-4 bg-light rounded">

                                <h3>Community</h3>

                                <p>We believe in the power of community support and connection in the recovery journey.</p>

                            </div>

                        </div>

                    </div>

                </div>

                

                <!-- Get Involved Section -->

                <div class="get-involved mt-5 mb-5">

                    <h2 class="text-center mb-4">Get Involved</h2>

                    <p>There are several ways to get involved with SoberList:</p>

                    <ul>

             

                        <li><a href="/contact">Contact us</a> with feedback or suggestions</li>

                        <li>Share SoberList with those who might benefit from our resources</li>

                    </ul>

                </div>

            </div>

        </div>

    </div>

</div>



<?php

// Include footer

include(BASE_PATH . '/app/Views/components/footer.php');

?>