<?php

/**

 * Home Page Logic

 * 

 * This file contains all the PHP logic needed for the home page functionality.

 */



// Make sure we have a database connection

global $db;



// Get total resources count

try {

    $stmt = $db->prepare("SELECT COUNT(*) FROM facilities WHERE active = 1");

    $stmt->execute();

    $total_resources = $stmt->fetchColumn();

} catch (PDOException $e) {

    // Fallback to default if query fails

    error_log("Error getting resource count: " . $e->getMessage());

    $total_resources = 20000;

}



// Get counts by facility type

try {

    $stmt = $db->prepare("

        SELECT facility_type, COUNT(*) as count 

        FROM facilities 

        WHERE active = 1 

        GROUP BY facility_type

    ");

    $stmt->execute();

    $type_counts = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    

    // Set variables for specific types

    $sober_living_count = $type_counts['HH'] ?? 0;

    $treatment_count = $type_counts['SA'] ?? 0;

    $detox_count = $type_counts['DT'] ?? 0;

    $mental_health_count = $type_counts['MH'] ?? 0;

} catch (PDOException $e) {

    // Fallback to defaults

    error_log("Error getting facility type counts: " . $e->getMessage());

    $sober_living_count = 8500;

    $treatment_count = 6200;

    $detox_count = 3100;

    $mental_health_count = 2200;

}



// Get testimonials

try {

    $stmt = $db->prepare("

        SELECT content, author, position 

        FROM testimonials 

        WHERE active = 1 

        ORDER BY position ASC 

        LIMIT 2

    ");

    $stmt->execute();

    $testimonials = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {

    // Fallback to sample testimonials

    error_log("Error getting testimonials: " . $e->getMessage());

    $testimonials = [

        [

            'content' => 'SoberList helped me find a sober living home when I was discharged from treatment with nowhere to go. The comprehensive directory made it easy to find several options in my area.',

            'author' => 'Michael T., In recovery since 2023',

            'position' => 1

        ],

        [

            'content' => 'As a treatment center director, I\'m excited about the upcoming bed availability system. This will streamline our admissions process and help us connect with individuals seeking help much faster.',

            'author' => 'Sarah K., Treatment Center Director',

            'position' => 2

        ]

    ];

}



// Get featured facilities if needed

if ($show_featured_resources) {

    try {

        $stmt = $db->prepare("

            SELECT f.*, AVG(r.rating) as avg_rating

            FROM facilities f

            LEFT JOIN reviews r ON f.id = r.facility_id

            WHERE f.active = 1 AND f.is_featured = 1

            GROUP BY f.id

            ORDER BY avg_rating DESC

            LIMIT 3

        ");

        $stmt->execute();

        $featured_facilities = $stmt->fetchAll(PDO::FETCH_ASSOC);

    } catch (PDOException $e) {

        error_log("Error getting featured facilities: " . $e->getMessage());

        $featured_facilities = [];

    }

}