<?php
/**
 * Privacy Policy Page - CleanKitchens.org
 */

// Include header (which loads config.php)
include(BASE_PATH . '/app/Views/components/header.php');
?>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto">
            <h1 class="text-center mb-4">Privacy Policy</h1>
            
            <p class="lead text-center mb-5">
                Effective Date: <?php echo date('F j, Y'); ?>
            </p>
            
            <div class="card mb-4 border-0 bg-light">
                <div class="card-body p-4">
                    <h2 class="h5 card-title"><i class="bi bi-shield-lock me-2"></i>Summary</h2>
                    <p class="card-text mb-0">
                        CleanKitchens.org respects your privacy. We collect minimal data needed to provide our services, do not sell your personal information, and use industry-standard security practices.
                    </p>
                </div>
            </div>
            
            <h2 class="mb-3">1. Information We Collect</h2>
            <p>We collect the following information:</p>
            <ul>
                <li><strong>Usage Data:</strong> IP address, browser type, referring pages, pages visited, time spent</li>
                <li><strong>Cookies:</strong> Small data files stored on your device to enhance user experience</li>
                <li><strong>Contact Information:</strong> Email address and name (only if voluntarily provided)</li>
            </ul>
            
            <h2 class="mt-5 mb-3">2. How We Use Your Information</h2>
            <p>We use collected information for:</p>
            <ul>
                <li>Providing and improving our services</li>
                <li>Analyzing website usage to enhance user experience</li>
                <li>Responding to your inquiries and requests</li>
                <li>Detecting and preventing fraudulent activities</li>
            </ul>
            
            <h2 class="mt-5 mb-3">3. Data Sharing and Disclosure</h2>
            <p>We do not sell, rent, or trade your personal information. We may share information:</p>
            <ul>
                <li>With service providers who assist our operations</li>
                <li>To comply with legal obligations</li>
                <li>To protect our rights, privacy, safety, or property</li>
            </ul>
            
            <h2 class="mt-5 mb-3">4. Cookies and Tracking Technologies</h2>
            <p>
                We use cookies to enhance user experience, analyze website traffic, and personalize content. You can control cookies through your browser settings.
            </p>
            
            <h2 class="mt-5 mb-3">5. Your Rights and Choices</h2>
            <p>Depending on your location, you may have rights to:</p>
            <ul>
                <li>Access personal information we hold about you</li>
                <li>Request correction of inaccurate information</li>
                <li>Request deletion of your information</li>
                <li>Opt-out of certain data uses</li>
                <li>Withdraw consent for processing</li>
            </ul>
            
            <h2 class="mt-5 mb-3">6. Data Security</h2>
            <p>
                We implement appropriate technical and organizational measures to protect your personal information. However, no method of transmission or storage is 100% secure, and we cannot guarantee absolute security.
            </p>
            
            <h2 class="mt-5 mb-3">7. Children's Privacy</h2>
            <p>
                Our services are not directed to children under 13. We do not knowingly collect personal information from children. If you believe we have inadvertently collected information from a child, please contact us.
            </p>
            
            <h2 class="mt-5 mb-3">8. Changes to This Privacy Policy</h2>
            <p>
                We may update this Privacy Policy periodically. We will notify you of significant changes by posting the new policy on this page and updating the effective date.
            </p>
            
            <h2 class="mt-5 mb-3">9. Contact Us</h2>
            <p>
                If you have questions or concerns about this Privacy Policy, please contact us at:
            </p>
            <p>
                <i class="bi bi-envelope me-2"></i>privacy@cleankitchens.org
            </p>
        </div>
    </div>
</div>

<?php
// Include footer
include(BASE_PATH . '/app/Views/components/footer.php');
?>index.php