<?php
/**
 * Terms of Service Page Configuration
 * CleanKitchens.org
 */

// Set page title and meta information
$page_title = "Terms of Service | CleanKitchens.org";
$meta_description = "Read our Terms of Service to understand the conditions for using CleanKitchens.org. Learn about user conduct, content disclaimers, and liability limitations.";
$keywords = "terms of service, terms and conditions, user agreement, legal terms, disclaimer";

// Open Graph metadata
$og_title = "Terms of Service | CleanKitchens.org";
$og_description = "Read our Terms of Service to understand the conditions for using CleanKitchens.org.";
$og_image = "/assets/images/legal-document.jpg";
$og_type = "website";

// Schema.org structured data JSON-LD
$schema_json = '{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "https://www.cleankitchens.org/terms"
  },
  "headline": "Terms of Service",
  "description": "Read our Terms of Service to understand the conditions for using CleanKitchens.org. Learn about user conduct, content disclaimers, and liability limitations.",
  "publisher": {
    "@type": "Organization",
    "name": "CleanKitchens.org",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.cleankitchens.org/assets/images/logo.png"
    }
  },
  "datePublished": "2025-03-28",
  "dateModified": "2025-03-28"
}';

// Set breadcrumbs data if needed
$breadcrumbs = [
  [
    'url' => '/',
    'text' => 'Home'
  ],
  [
    'url' => '/terms',
    'text' => 'Terms of Service',
    'current' => true
  ]
];