@echo off
title Find Python Installation
color 0A

echo ============================================
echo   SEARCHING FOR PYTHON INSTALLATION
echo ============================================
echo.

echo Searching for Python... This may take a moment...
echo.

set FOUND=0

echo Checking standard locations:
echo ----------------------------

REM Check Users folder installations
for /d %%i in ("%LOCALAPPDATA%\Programs\Python\Python*") do (
    if exist "%%i\python.exe" (
        echo FOUND: %%i\python.exe
        set FOUND=1
        set PYTHON_PATH=%%i
    )
)

REM Check AppData Roaming
for /d %%i in ("%APPDATA%\Python\Python*") do (
    if exist "%%i\python.exe" (
        echo FOUND: %%i\python.exe
        set FOUND=1
        set PYTHON_PATH=%%i
    )
)

REM Check Program Files
for /d %%i in ("%ProgramFiles%\Python*") do (
    if exist "%%i\python.exe" (
        echo FOUND: %%i\python.exe
        set FOUND=1
        set PYTHON_PATH=%%i
    )
)

REM Check Program Files (x86)
for /d %%i in ("%ProgramFiles(x86)%\Python*") do (
    if exist "%%i\python.exe" (
        echo FOUND: %%i\python.exe
        set FOUND=1
        set PYTHON_PATH=%%i
    )
)

REM Check C:\ root
for /d %%i in ("C:\Python*") do (
    if exist "%%i\python.exe" (
        echo FOUND: %%i\python.exe
        set FOUND=1
        set PYTHON_PATH=%%i
    )
)

REM Check if installed from Microsoft Store
if exist "%LOCALAPPDATA%\Microsoft\WindowsApps\python.exe" (
    echo FOUND: %LOCALAPPDATA%\Microsoft\WindowsApps\python.exe (Microsoft Store version)
    set FOUND=1
    set PYTHON_PATH=%LOCALAPPDATA%\Microsoft\WindowsApps
)

REM Check user's home directory
if exist "%USERPROFILE%\python.exe" (
    echo FOUND: %USERPROFILE%\python.exe
    set FOUND=1
    set PYTHON_PATH=%USERPROFILE%
)

echo.
echo Searching entire C: drive for python.exe...
echo (This may take a minute)
echo.

REM Last resort - search entire C drive
dir C:\python.exe /s /b 2>nul | findstr /i "python.exe" > temp_python_locations.txt

if exist temp_python_locations.txt (
    for /f "tokens=*" %%i in (temp_python_locations.txt) do (
        echo FOUND: %%i
        set FOUND=1
        if not defined PYTHON_PATH set PYTHON_PATH=%%~dpi
    )
    del temp_python_locations.txt
)

echo.
echo ============================================
echo   SEARCH COMPLETE
echo ============================================
echo.

if %FOUND%==0 (
    echo NO PYTHON INSTALLATION FOUND!
    echo.
    echo Python doesn't appear to be installed.
    echo.
    echo To install Python:
    echo 1. Go to https://www.python.org/downloads/
    echo 2. Download Python 3.11 or 3.12
    echo 3. Run the installer
    echo 4. IMPORTANT: Check "Add Python to PATH" at the bottom!
    echo.
) else (
    echo Python was found but not added to PATH.
    echo.
    if defined PYTHON_PATH (
        echo Location: %PYTHON_PATH%
        echo.
        echo Testing if it works...
        "%PYTHON_PATH%\python.exe" --version
        echo.
        echo ============================================
        echo   FIX INSTRUCTIONS
        echo ============================================
        echo.
        echo Option 1: Add to PATH manually
        echo --------------------------------
        echo 1. Press Windows+X, select "System"
        echo 2. Click "Advanced system settings"
        echo 3. Click "Environment Variables"
        echo 4. Under "System variables", find "Path", click Edit
        echo 5. Click "New" and add: %PYTHON_PATH%
        echo 6. Click OK on all windows
        echo 7. Restart Command Prompt
        echo.
        echo Option 2: Reinstall Python
        echo ---------------------------
        echo 1. Uninstall current Python
        echo 2. Download from python.org
        echo 3. CHECK "Add Python to PATH" during install!
        echo.
        echo Option 3: Create a shortcut that works
        echo ---------------------------------------
        echo Creating a working shortcut for you...
        
        REM Create a batch file that uses the found Python
        (
            echo @echo off
            echo "%PYTHON_PATH%\python.exe" %%*
        ) > "%USERPROFILE%\Desktop\python_fixed.bat"
        
        echo.
        echo Created: Desktop\python_fixed.bat
        echo You can use this instead of 'python' command
    )
)

echo.
echo ============================================
echo Press any key to exit...
pause >nul