<?php
require_once 'auth.php';
requireLogin();

$currentPage = 'analytics';

require_once '../includes/config.php';
require_once 'admin-functions.php';

// Get analytics data for different periods
$analytics7Days = getAnalyticsData(7);
$analytics30Days = getAnalyticsData(30);

// Get top performing articles
$topArticles = getPopularArticles(10);

// Get traffic sources (mock data for now)
$trafficSources = [
    ['source' => 'Google', 'visits' => rand(5000, 10000), 'percentage' => 45],
    ['source' => 'Direct', 'visits' => rand(3000, 7000), 'percentage' => 30],
    ['source' => 'Social Media', 'visits' => rand(1000, 3000), 'percentage' => 15],
    ['source' => 'Referral', 'visits' => rand(500, 2000), 'percentage' => 10],
];

// Get device stats (mock data)
$deviceStats = [
    ['device' => 'Mobile', 'percentage' => 65, 'color' => '#667eea'],
    ['device' => 'Desktop', 'percentage' => 30, 'color' => '#48bb78'],
    ['device' => 'Tablet', 'percentage' => 5, 'color' => '#f6ad55'],
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analytics - CleanKitchens Admin</title>
    <link rel="stylesheet" href="admin-styles.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <div class="admin-wrapper">
        <?php include 'includes/sidebar.php'; ?>
        
        <div class="admin-content">
            <?php include 'includes/header.php'; ?>
            
            <div class="dashboard">
                <h1>Analytics Overview</h1>
                
                <!-- Quick Stats -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">👁️</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format(array_sum($analytics7Days['pageviews'])) ?></div>
                            <div class="stat-label">Page Views (7 days)</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">👥</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format(array_sum($analytics7Days['users'])) ?></div>
                            <div class="stat-label">Unique Users (7 days)</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">📊</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format(array_sum($analytics7Days['sessions'])) ?></div>
                            <div class="stat-label">Sessions (7 days)</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">⏱️</div>
                        <div class="stat-details">
                            <div class="stat-value">2:45</div>
                            <div class="stat-label">Avg. Session Duration</div>
                        </div>
                    </div>
                </div>
                
                <!-- Traffic Chart -->
                <div class="card">
                    <div class="card-header">
                        <h2>Traffic Overview</h2>
                        <div>
                            <button class="btn btn-sm" onclick="switchChart('7days')">7 Days</button>
                            <button class="btn btn-sm" onclick="switchChart('30days')">30 Days</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="trafficChart" height="80"></canvas>
                    </div>
                </div>
                
                <div class="grid-2">
                    <!-- Top Articles -->
                    <div class="card">
                        <div class="card-header">
                            <h2>Top Articles</h2>
                        </div>
                        <div class="card-body">
                            <div class="article-list">
                                <?php foreach ($topArticles as $index => $article): ?>
                                <div class="article-item">
                                    <div style="display: flex; align-items: center; gap: 15px;">
                                        <span style="font-size: 1.5rem; color: #cbd5e0; font-weight: bold;">
                                            <?= $index + 1 ?>
                                        </span>
                                        <div class="article-info" style="flex: 1;">
                                            <a href="/<?= htmlspecialchars($article['slug']) ?>" target="_blank" class="article-title">
                                                <?= htmlspecialchars($article['title']) ?>
                                            </a>
                                            <div class="article-meta">
                                                <?= number_format($article['views']) ?> views • 
                                                <?= $article['avg_time'] ?>s avg time
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Traffic Sources -->
                    <div class="card">
                        <div class="card-header">
                            <h2>Traffic Sources</h2>
                        </div>
                        <div class="card-body">
                            <?php foreach ($trafficSources as $source): ?>
                            <div style="margin-bottom: 20px;">
                                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                                    <span><?= $source['source'] ?></span>
                                    <span style="font-weight: 600;"><?= number_format($source['visits']) ?></span>
                                </div>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: <?= $source['percentage'] ?>%"></div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Device Stats -->
                <div class="card">
                    <div class="card-header">
                        <h2>Device Breakdown</h2>
                    </div>
                    <div class="card-body">
                        <div style="display: grid; grid-template-columns: 300px 1fr; gap: 40px; align-items: center;">
                            <canvas id="deviceChart"></canvas>
                            <div>
                                <?php foreach ($deviceStats as $device): ?>
                                <div style="display: flex; align-items: center; margin-bottom: 15px;">
                                    <div style="width: 20px; height: 20px; background: <?= $device['color'] ?>; 
                                              border-radius: 4px; margin-right: 10px;"></div>
                                    <span style="flex: 1;"><?= $device['device'] ?></span>
                                    <span style="font-weight: 600;"><?= $device['percentage'] ?>%</span>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Traffic Chart
        const ctx = document.getElementById('trafficChart').getContext('2d');
        let trafficChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?= json_encode($analytics7Days['dates']) ?>,
                datasets: [{
                    label: 'Page Views',
                    data: <?= json_encode($analytics7Days['pageviews']) ?>,
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.3
                }, {
                    label: 'Users',
                    data: <?= json_encode($analytics7Days['users']) ?>,
                    borderColor: '#48bb78',
                    backgroundColor: 'rgba(72, 187, 120, 0.1)',
                    tension: 0.3
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
        
        // Device Chart (Donut)
        const deviceCtx = document.getElementById('deviceChart').getContext('2d');
        new Chart(deviceCtx, {
            type: 'doughnut',
            data: {
                labels: <?= json_encode(array_column($deviceStats, 'device')) ?>,
                datasets: [{
                    data: <?= json_encode(array_column($deviceStats, 'percentage')) ?>,
                    backgroundColor: <?= json_encode(array_column($deviceStats, 'color')) ?>
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
        
        function switchChart(period) {
            // Would implement chart switching here
            console.log('Switching to', period);
        }
    </script>
</body>
</html>