<?php
session_start();

// Simple authentication configuration
define('ADMIN_USER', 'chris');
define('ADMIN_PASS_HASH', '$2y$10$' . substr(base64_encode(hash('sha256', 'coffee' . 'cleankitchens_salt', true)), 0, 22));

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

// Login function
function login($username, $password) {
    if ($username === ADMIN_USER && $password === 'coffee') {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_user'] = $username;
        $_SESSION['login_time'] = time();
        return true;
    }
    return false;
}

// Logout function
function logout() {
    session_destroy();
    header('Location: /admin/login.php');
    exit;
}

// Protect admin pages
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: /admin/login.php?redirect=' . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
    
    // Session timeout after 4 hours
    if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time'] > 14400)) {
        logout();
    }
    
    // Update activity time
    $_SESSION['login_time'] = time();
}

// CSRF protection
function generateCSRFToken() {
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}
?>