<?php
// SIMPLE ARTICLE VIEWER
require_once 'includes/config.php';
require_once 'functions_simple.php';

// Get slug from URL parameter
$slug = isset($_GET['slug']) ? $_GET['slug'] : '';

if (empty($slug)) {
    header("Location: /");
    exit;
}

// Get article from database
$article = getArticleBySlug($slug);

if (!$article) {
    // Article not found
    $pageType = 'static';
    $pageData = [
        'title' => 'Article Not Found',
        'description' => 'The requested article was not found.'
    ];
    
    include 'includes/head.php';
    include 'includes/nav.php';
    ?>
    <main id="main-content">
        <div class="container">
            <div class="static-content">
                <h1>Article Not Found</h1>
                <p>Sorry, we couldn't find the article you're looking for.</p>
                <p><a href="/">← Back to Homepage</a></p>
            </div>
        </div>
    </main>
    <?php
    include 'includes/footer.php';
    exit;
}

// Article found
$pageType = 'article';
$relatedArticles = getRelatedArticles($slug);

include 'includes/head.php';
include 'includes/nav.php';
?>

<main id="main-content">
    <div class="container">
        <article class="article-wrapper">
            <header class="article-header">
                <div class="article-meta">
                    <span><?= $article['city'] ?>, <?= $article['state'] ?></span>
                    <span>•</span>
                    <span><?= date('F j, Y', strtotime($article['published_date'])) ?></span>
                    <span>•</span>
                    <span>2 min read</span>
                </div>
                <h1 class="article-title"><?= htmlspecialchars($article['title']) ?></h1>
            </header>

            <div class="article-image">
                <picture>
                    <source srcset="<?= getImageSrcSet(getArticleImage($article), [600, 800, 1200]) ?>" 
                            type="image/webp"
                            sizes="100vw">
                    <img src="<?= getOptimizedImageUrl('', 'article', $article) ?>" 
                         alt="<?= htmlspecialchars($article['establishment_name']) ?> restaurant inspection" 
                         width="1200" height="630"
                         loading="eager"
                         fetchpriority="high">
                </picture>
            </div>

            <div class="article-content">
                <?= $article['content'] ?>
            </div>

            <?php if (!empty($article['tags'])): ?>
            <div class="article-tags">
                <?php foreach ($article['tags'] as $tag): ?>
                    <span class="tag"><?= htmlspecialchars($tag) ?></span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </article>
    </div>

    <!-- Related Articles -->
    <?php if (!empty($relatedArticles)): ?>
    <section class="container related-section">
        <h2 class="section-title">Related Stories</h2>
        <div class="row">
            <?php foreach ($relatedArticles as $related): ?>
            <div class="col col-md-4">
                <div class="related-card">
                    <h3><a href="/<?= htmlspecialchars($related['slug']) ?>"><?= htmlspecialchars($related['title']) ?></a></h3>
                    <p class="related-meta"><?= $related['city'] ?>, <?= $related['state'] ?> • <?= timeAgo($related['published_date']) ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>
    <?php endif; ?>
</main>

<?php include 'includes/footer.php'; ?>