<?php
/**
 * Data Sources Page - CleanKitchens
 * Transparency page showing where our inspection data comes from
 */

require_once 'includes/config.php';
require_once 'functions.php';
require_once 'functions_live.php';

// Page configuration
$pageType = 'static';
$pageData = [
    'title' => 'Data Sources - Restaurant Health Inspection Data',
    'description' => 'Learn where CleanKitchens sources its restaurant health inspection data. We use official government APIs and open data portals for transparency.',
    'h1' => 'Our Data Sources'
];
$staticPage = 'data-sources';

// Start output
include 'includes/head.php';
include 'includes/nav.php';
?>

<main id="main-content">
<div class="container">
    <div class="static-content">
        <h1>Our Data Sources</h1>
        
        <p class="lead">
            Transparency is core to our mission. All restaurant inspection data on CleanKitchens is sourced directly from official government health departments.
        </p>
        
        <div class="alert alert-info">
            <strong>🔍 100% Official Data:</strong> We never alter inspection results or scores. All data comes directly from government sources.
        </div>
        
        <h2>How We Collect Data</h2>
        <p>CleanKitchens collects restaurant health inspection data through several official channels:</p>
        
        <ol>
            <li><strong>Public Records APIs:</strong> We connect directly to health department APIs for real-time data access.</li>
            <li><strong>Open Data Portals:</strong> We access municipal open data portals that publish inspection results.</li>
            <li><strong>CSV Downloads:</strong> For jurisdictions without APIs, we process official CSV data files.</li>
            <li><strong>Freedom of Information Act (FOIA) Requests:</strong> We file formal requests for data under public records laws when necessary.</li>
        </ol>
        
        <h2>Currently Active Data Sources</h2>
        
        <h3>Chicago, Illinois</h3>
        <ul>
            <li><strong>Source:</strong> Chicago Department of Public Health</li>
            <li><strong>API:</strong> Chicago Data Portal API</li>
            <li><strong>Update Frequency:</strong> Daily</li>
            <li><strong>Records:</strong> 295,000+ historical inspections</li>
            <li><strong>Coverage:</strong> All food establishments in Chicago</li>
            <li><strong>Official Portal:</strong> <a href="https://data.cityofchicago.org/Health-Human-Services/Food-Inspections/4ijn-s7e5" target="_blank" rel="noopener">Chicago Food Inspections Dataset</a></li>
        </ul>
        
        <h3>Coming Soon</h3>
        <p>We're actively working to add data from:</p>
        <ul>
            <li><strong>New York City</strong> - NYC Department of Health (DOHMH)</li>
            <li><strong>Los Angeles</strong> - LA County Department of Public Health</li>
            <li><strong>San Francisco</strong> - SF Department of Public Health</li>
            <li><strong>Boston</strong> - Boston Public Health Commission</li>
            <li><strong>Seattle</strong> - King County Public Health</li>
        </ul>
        
        <h2>Data Update Schedule</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>Data Type</th>
                    <th>Update Frequency</th>
                    <th>Typical Delay</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>API-Connected Cities</td>
                    <td>Daily</td>
                    <td>24-48 hours</td>
                </tr>
                <tr>
                    <td>CSV Downloads</td>
                    <td>Weekly</td>
                    <td>3-7 days</td>
                </tr>
                <tr>
                    <td>FOIA Requests</td>
                    <td>Monthly</td>
                    <td>30-45 days</td>
                </tr>
            </tbody>
        </table>
        
        <h2>Understanding Our Data</h2>
        
        <h3>Violation Categories</h3>
        <p>Different health departments categorize violations differently. Common categories include:</p>
        <ul>
            <li><strong>Critical Violations:</strong> Directly related to factors that lead to foodborne illness</li>
            <li><strong>Non-Critical Violations:</strong> General sanitation and operational issues</li>
            <li><strong>Core Violations:</strong> Basic food safety requirements</li>
        </ul>
        
        <h3>Inspection Types</h3>
        <ul>
            <li><strong>Routine:</strong> Regular scheduled inspections</li>
            <li><strong>Complaint:</strong> Triggered by customer complaints</li>
            <li><strong>Re-inspection:</strong> Follow-up after violations found</li>
            <li><strong>Pre-operational:</strong> Before opening or ownership change</li>
        </ul>
        
        <h2>Data Processing & Quality</h2>
        
        <h3>Our Process</h3>
        <ol>
            <li><strong>Collection:</strong> Automated import from official sources</li>
            <li><strong>Validation:</strong> Check for data completeness and accuracy</li>
            <li><strong>Deduplication:</strong> Remove duplicate records</li>
            <li><strong>Standardization:</strong> Normalize data formats across jurisdictions</li>
            <li><strong>Vectorization:</strong> Create semantic search capabilities</li>
            <li><strong>Publishing:</strong> Generate educational articles with context</li>
        </ol>
        
        <h3>Quality Assurance</h3>
        <p>We maintain data quality through:</p>
        <ul>
            <li>Automated validation checks during import</li>
            <li>Duplicate detection algorithms</li>
            <li>Regular audits against source data</li>
            <li>User feedback and correction mechanisms</li>
        </ul>
        
        <h2>Data Limitations</h2>
        
        <div class="alert alert-warning">
            <strong>Important Limitations to Understand:</strong>
        </div>
        
        <ul>
            <li><strong>Reporting Delays:</strong> There can be delays between inspections and public reporting</li>
            <li><strong>Jurisdictional Differences:</strong> Different cities use different scoring systems</li>
            <li><strong>Follow-up Gaps:</strong> Re-inspections may not immediately appear</li>
            <li><strong>Historical Data:</strong> Older records may have less detail</li>
        </ul>
        
        <h2>Educational Use of Data</h2>
        <p>
            CleanKitchens transforms raw inspection data into educational content that helps consumers understand food safety principles. 
            Each article includes:
        </p>
        <ul>
            <li>Context about why violations matter</li>
            <li>Links to FDA, CDC, and USDA guidelines</li>
            <li>Practical food safety tips for home use</li>
            <li>FAQs to answer common questions</li>
        </ul>
        
        <h2>Contact for Data Questions</h2>
        <p>
            For questions about our data sources, corrections, or to suggest new jurisdictions to cover, 
            please contact us at <a href="mailto:data@cleankitchens.com">data@cleankitchens.com</a>
        </p>
        
        <h2>Legal & Compliance</h2>
        <p>
            All data is obtained through legal public records channels. We comply with all applicable laws including:
        </p>
        <ul>
            <li>Freedom of Information Act (FOIA)</li>
            <li>State public records laws</li>
            <li>Municipal open data policies</li>
            <li>Terms of use for public APIs</li>
        </ul>
        
        <div class="alert alert-success mt-5">
            <strong>✅ Our Commitment:</strong> We are committed to providing accurate, timely, and educational information 
            about restaurant health inspections to help consumers make informed dining decisions.
        </div>
    </div>
</div>
</main>

<style>
.static-content table {
    margin: 20px 0;
    width: 100%;
    border-collapse: collapse;
}
.static-content th {
    background: var(--accent-color);
    color: white;
    padding: 12px;
    text-align: left;
}
.static-content td {
    padding: 12px;
    border-bottom: 1px solid var(--border-color);
}
.static-content .alert {
    padding: 16px;
    border-radius: 8px;
    margin: 20px 0;
}
.static-content .alert-info {
    background: #d1ecf1;
    color: #0c5460;
    border-left: 4px solid #17a2b8;
}
.static-content .alert-warning {
    background: #fff3cd;
    color: #856404;
    border-left: 4px solid #ffc107;
}
.static-content .alert-success {
    background: #d4edda;
    color: #155724;
    border-left: 4px solid #28a745;
}
.lead {
    font-size: 1.25rem;
    font-weight: 300;
    line-height: 1.6;
}
</style>

<?php include 'includes/footer.php'; ?>