@echo off
title SF Smart Collector - Fresh Install
color 0A

echo ============================================
echo   SF SMART COLLECTOR - CLEAN INSTALLATION
echo   Removes old versions and data
echo   Sets up fresh with 6 daily runs
echo ============================================
echo.

REM Set up paths
set PYTHON_EXE=C:\Python313\python.exe
set INSTALL_DIR=%LOCALAPPDATA%\SFCollector
set SCRIPT_FILE=%INSTALL_DIR%\sf_smart_collector.py
set TRACKER_FILE=%INSTALL_DIR%\tracker.json
set ERROR_LOG=%INSTALL_DIR%\errors.json
set RUN_LOG=%INSTALL_DIR%\run_history.log

REM Check Python
echo Checking Python installation...
if not exist "%PYTHON_EXE%" (
    echo ERROR: Python not found at %PYTHON_EXE%
    pause
    exit /b 1
)
"%PYTHON_EXE%" --version
echo.

REM CLEAN UP OLD INSTALLATIONS
echo ============================================
echo   CLEANING UP OLD INSTALLATIONS
echo ============================================
echo.

REM Remove old scheduled tasks
echo Removing old scheduled tasks...
schtasks /delete /tn "SF_Collector_Morning" /f >nul 2>&1
schtasks /delete /tn "SF_Collector_Evening" /f >nul 2>&1
schtasks /delete /tn "SF_Smart_Collector_12AM" /f >nul 2>&1
schtasks /delete /tn "SF_Smart_Collector_4AM" /f >nul 2>&1
schtasks /delete /tn "SF_Smart_Collector_8AM" /f >nul 2>&1
schtasks /delete /tn "SF_Smart_Collector_12PM" /f >nul 2>&1
schtasks /delete /tn "SF_Smart_Collector_4PM" /f >nul 2>&1
schtasks /delete /tn "SF_Smart_Collector_8PM" /f >nul 2>&1
echo Old tasks removed.
echo.

REM Ask about data deletion
echo Do you want to delete old tracking data? (Y/N)
echo This will make the collector start fresh from the beginning.
set /p DELETE_DATA=
if /i "%DELETE_DATA%"=="Y" (
    echo Deleting old data...
    if exist "%TRACKER_FILE%" del "%TRACKER_FILE%"
    if exist "%ERROR_LOG%" del "%ERROR_LOG%"
    if exist "%RUN_LOG%" del "%RUN_LOG%"
    if exist "%INSTALL_DIR%\temp" rmdir /s /q "%INSTALL_DIR%\temp"
    echo Old data deleted.
) else (
    echo Keeping existing tracking data.
)
echo.

REM Create directory
echo Creating installation directory...
if not exist "%INSTALL_DIR%" mkdir "%INSTALL_DIR%"

REM Create the smart Python collector script
echo Creating smart collector script...
echo # SF Smart Collector with Search > "%SCRIPT_FILE%"
echo import os >> "%SCRIPT_FILE%"
echo import sys >> "%SCRIPT_FILE%"
echo import time >> "%SCRIPT_FILE%"
echo import json >> "%SCRIPT_FILE%"
echo import base64 >> "%SCRIPT_FILE%"
echo import warnings >> "%SCRIPT_FILE%"
echo from datetime import datetime >> "%SCRIPT_FILE%"
echo import hashlib >> "%SCRIPT_FILE%"
echo import traceback >> "%SCRIPT_FILE%"
echo import random >> "%SCRIPT_FILE%"
echo warnings.filterwarnings('ignore') >> "%SCRIPT_FILE%"
echo os.environ['WDM_LOG'] = '0' >> "%SCRIPT_FILE%"
echo os.environ['WDM_PROGRESS'] = '0' >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo print('SF SMART COLLECTOR - INCREMENTAL MODE') >> "%SCRIPT_FILE%"
echo print('='*50) >> "%SCRIPT_FILE%"
echo print(f'Started at: {datetime.now().strftime("%%Y-%%m-%%d %%H:%%M:%%S")}') >> "%SCRIPT_FILE%"
echo print() >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo # Configuration >> "%SCRIPT_FILE%"
echo SERVER_URL = 'https://cleankitchens.org/data/sf/api_receiver_v2.php' >> "%SCRIPT_FILE%"
echo API_KEY = 'sk-sf-inspections-2025' >> "%SCRIPT_FILE%"
echo MAX_PER_RUN = 10  # Max inspections per run >> "%SCRIPT_FILE%"
echo MAX_SHOW_MORE = 20  # Max times to click Show More >> "%SCRIPT_FILE%"
echo FIRST_RUN_SHOW_MORE = 5  # Click Show More 5 times on first run >> "%SCRIPT_FILE%"
echo MIN_WAIT = 2  # Min seconds between actions >> "%SCRIPT_FILE%"
echo MAX_WAIT = 5  # Max seconds between actions >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo # File paths >> "%SCRIPT_FILE%"
echo TRACKER_FILE = os.path.join(os.path.dirname(__file__), 'tracker.json') >> "%SCRIPT_FILE%"
echo ERROR_LOG = os.path.join(os.path.dirname(__file__), 'errors.json') >> "%SCRIPT_FILE%"
echo RUN_LOG = os.path.join(os.path.dirname(__file__), 'run_history.log') >> "%SCRIPT_FILE%"
echo TEMP_DIR = os.path.join(os.path.dirname(__file__), 'temp') >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo # Create temp directory >> "%SCRIPT_FILE%"
echo if not os.path.exists(TEMP_DIR): >> "%SCRIPT_FILE%"
echo     os.makedirs(TEMP_DIR) >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def random_wait(): >> "%SCRIPT_FILE%"
echo     """Random wait between actions to seem more human""" >> "%SCRIPT_FILE%"
echo     wait_time = random.uniform(MIN_WAIT, MAX_WAIT) >> "%SCRIPT_FILE%"
echo     time.sleep(wait_time) >> "%SCRIPT_FILE%"
echo     return wait_time >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def log_to_file(message): >> "%SCRIPT_FILE%"
echo     """Write to run history log""" >> "%SCRIPT_FILE%"
echo     timestamp = datetime.now().strftime('%%Y-%%m-%%d %%H:%%M:%%S') >> "%SCRIPT_FILE%"
echo     log_entry = f'[{timestamp}] {message}' >> "%SCRIPT_FILE%"
echo     with open(RUN_LOG, 'a', encoding='utf-8') as f: >> "%SCRIPT_FILE%"
echo         f.write(log_entry + '\n') >> "%SCRIPT_FILE%"
echo     print(message) >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def load_tracker(): >> "%SCRIPT_FILE%"
echo     """Load tracking data""" >> "%SCRIPT_FILE%"
echo     if os.path.exists(TRACKER_FILE): >> "%SCRIPT_FILE%"
echo         try: >> "%SCRIPT_FILE%"
echo             with open(TRACKER_FILE, 'r') as f: >> "%SCRIPT_FILE%"
echo                 return json.load(f) >> "%SCRIPT_FILE%"
echo         except: >> "%SCRIPT_FILE%"
echo             return {} >> "%SCRIPT_FILE%"
echo     return {} >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def save_tracker(data): >> "%SCRIPT_FILE%"
echo     """Save tracking data""" >> "%SCRIPT_FILE%"
echo     with open(TRACKER_FILE, 'w') as f: >> "%SCRIPT_FILE%"
echo         json.dump(data, f, indent=2) >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo try: >> "%SCRIPT_FILE%"
echo     from selenium import webdriver >> "%SCRIPT_FILE%"
echo     from selenium.webdriver.common.by import By >> "%SCRIPT_FILE%"
echo     from selenium.webdriver.chrome.options import Options >> "%SCRIPT_FILE%"
echo     from selenium.webdriver.chrome.service import Service >> "%SCRIPT_FILE%"
echo     from webdriver_manager.chrome import ChromeDriverManager >> "%SCRIPT_FILE%"
echo     import requests >> "%SCRIPT_FILE%"
echo except ImportError: >> "%SCRIPT_FILE%"
echo     log_to_file('Installing required packages...') >> "%SCRIPT_FILE%"
echo     import subprocess >> "%SCRIPT_FILE%"
echo     subprocess.run([sys.executable, '-m', 'pip', 'install', 'selenium', 'requests', 'webdriver-manager']) >> "%SCRIPT_FILE%"
echo     from selenium import webdriver >> "%SCRIPT_FILE%"
echo     from selenium.webdriver.common.by import By >> "%SCRIPT_FILE%"
echo     from selenium.webdriver.chrome.options import Options >> "%SCRIPT_FILE%"
echo     from selenium.webdriver.chrome.service import Service >> "%SCRIPT_FILE%"
echo     from webdriver_manager.chrome import ChromeDriverManager >> "%SCRIPT_FILE%"
echo     import requests >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def upload_to_server(inspection_data, pdf_path): >> "%SCRIPT_FILE%"
echo     """Upload inspection data and PDF to server""" >> "%SCRIPT_FILE%"
echo     try: >> "%SCRIPT_FILE%"
echo         with open(pdf_path, 'rb') as f: >> "%SCRIPT_FILE%"
echo             pdf_content = f.read() >> "%SCRIPT_FILE%"
echo         payload = { >> "%SCRIPT_FILE%"
echo             'action': 'upload_inspection', >> "%SCRIPT_FILE%"
echo             'inspection_id': inspection_data['id'], >> "%SCRIPT_FILE%"
echo             'facility_name': inspection_data['name'], >> "%SCRIPT_FILE%"
echo             'inspection_data': inspection_data, >> "%SCRIPT_FILE%"
echo             'pdf_base64': base64.b64encode(pdf_content).decode('utf-8'), >> "%SCRIPT_FILE%"
echo             'pdf_filename': os.path.basename(pdf_path) >> "%SCRIPT_FILE%"
echo         } >> "%SCRIPT_FILE%"
echo         headers = {'X-API-Key': API_KEY, 'Content-Type': 'application/json'} >> "%SCRIPT_FILE%"
echo         response = requests.post(SERVER_URL, json=payload, headers=headers, timeout=30) >> "%SCRIPT_FILE%"
echo         if response.status_code == 200: >> "%SCRIPT_FILE%"
echo             result = response.json() >> "%SCRIPT_FILE%"
echo             if result.get('success'): >> "%SCRIPT_FILE%"
echo                 return True, "Success" >> "%SCRIPT_FILE%"
echo             else: >> "%SCRIPT_FILE%"
echo                 return False, result.get('error', 'Unknown error') >> "%SCRIPT_FILE%"
echo         else: >> "%SCRIPT_FILE%"
echo             return False, f"HTTP {response.status_code}" >> "%SCRIPT_FILE%"
echo     except Exception as e: >> "%SCRIPT_FILE%"
echo         return False, str(e) >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def get_all_inspections_on_page(driver): >> "%SCRIPT_FILE%"
echo     """Get all inspection links currently visible on page""" >> "%SCRIPT_FILE%"
echo     inspections = [] >> "%SCRIPT_FILE%"
echo     links = driver.find_elements(By.TAG_NAME, 'a') >> "%SCRIPT_FILE%"
echo     for link in links: >> "%SCRIPT_FILE%"
echo         try: >> "%SCRIPT_FILE%"
echo             href = link.get_attribute('href') or '' >> "%SCRIPT_FILE%"
echo             if 'inspectionID=' in href: >> "%SCRIPT_FILE%"
echo                 name = link.text.strip() >> "%SCRIPT_FILE%"
echo                 if name: >> "%SCRIPT_FILE%"
echo                     parts = href.split('inspectionID=') >> "%SCRIPT_FILE%"
echo                     if len(parts) ^> 1: >> "%SCRIPT_FILE%"
echo                         inspection_id = parts[1] >> "%SCRIPT_FILE%"
echo                         inspections.append({'id': inspection_id, 'url': href, 'name': name}) >> "%SCRIPT_FILE%"
echo         except: >> "%SCRIPT_FILE%"
echo             continue >> "%SCRIPT_FILE%"
echo     return inspections >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def find_last_inspection(driver, last_id, is_first_run=False): >> "%SCRIPT_FILE%"
echo     """Keep clicking Show More until we find the last inspection we processed""" >> "%SCRIPT_FILE%"
echo     # First run - just click Show More 5 times to get initial data >> "%SCRIPT_FILE%"
echo     if is_first_run or not last_id: >> "%SCRIPT_FILE%"
echo         log_to_file('First run - clicking Show More 5 times to load initial data') >> "%SCRIPT_FILE%"
echo         for i in range(FIRST_RUN_SHOW_MORE): >> "%SCRIPT_FILE%"
echo             try: >> "%SCRIPT_FILE%"
echo                 load_more = driver.find_element(By.CLASS_NAME, 'load-more-results-button') >> "%SCRIPT_FILE%"
echo                 if load_more.is_displayed() and load_more.is_enabled(): >> "%SCRIPT_FILE%"
echo                     driver.execute_script("arguments[0].scrollIntoView();", load_more) >> "%SCRIPT_FILE%"
echo                     time.sleep(1) >> "%SCRIPT_FILE%"
echo                     load_more.click() >> "%SCRIPT_FILE%"
echo                     wait = random_wait() >> "%SCRIPT_FILE%"
echo                     log_to_file(f'Click #{i+1}: Loaded more results (waited {wait:.1f}s)') >> "%SCRIPT_FILE%"
echo                 else: >> "%SCRIPT_FILE%"
echo                     break >> "%SCRIPT_FILE%"
echo             except: >> "%SCRIPT_FILE%"
echo                 break >> "%SCRIPT_FILE%"
echo         inspections = get_all_inspections_on_page(driver) >> "%SCRIPT_FILE%"
echo         log_to_file(f'First run loaded {len(inspections)} total inspections') >> "%SCRIPT_FILE%"
echo         return inspections, len(inspections) >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Not first run - search for last inspection >> "%SCRIPT_FILE%"
echo     clicks = 0 >> "%SCRIPT_FILE%"
echo     max_clicks = MAX_SHOW_MORE >> "%SCRIPT_FILE%"
echo     while clicks ^< max_clicks: >> "%SCRIPT_FILE%"
echo         # Check current page for last inspection >> "%SCRIPT_FILE%"
echo         inspections = get_all_inspections_on_page(driver) >> "%SCRIPT_FILE%"
echo         for idx, insp in enumerate(inspections): >> "%SCRIPT_FILE%"
echo             if insp['id'] == last_id: >> "%SCRIPT_FILE%"
echo                 log_to_file(f'Found last inspection at position {idx+1} after {clicks} Show More clicks') >> "%SCRIPT_FILE%"
echo                 return inspections[:idx], idx  # Return all inspections BEFORE the last one >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Try to click Show More >> "%SCRIPT_FILE%"
echo         try: >> "%SCRIPT_FILE%"
echo             load_more = driver.find_element(By.CLASS_NAME, 'load-more-results-button') >> "%SCRIPT_FILE%"
echo             if load_more.is_displayed() and load_more.is_enabled(): >> "%SCRIPT_FILE%"
echo                 driver.execute_script("arguments[0].scrollIntoView();", load_more) >> "%SCRIPT_FILE%"
echo                 time.sleep(1) >> "%SCRIPT_FILE%"
echo                 load_more.click() >> "%SCRIPT_FILE%"
echo                 clicks += 1 >> "%SCRIPT_FILE%"
echo                 wait = random_wait() >> "%SCRIPT_FILE%"
echo                 log_to_file(f'Clicked Show More #{clicks}, now {len(inspections)} visible (waited {wait:.1f}s)') >> "%SCRIPT_FILE%"
echo             else: >> "%SCRIPT_FILE%"
echo                 log_to_file('Show More button not clickable') >> "%SCRIPT_FILE%"
echo                 break >> "%SCRIPT_FILE%"
echo         except: >> "%SCRIPT_FILE%"
echo             log_to_file('No more Show More button') >> "%SCRIPT_FILE%"
echo             break >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     log_to_file(f'Last inspection not found after {clicks} clicks - will process all') >> "%SCRIPT_FILE%"
echo     return get_all_inspections_on_page(driver), len(get_all_inspections_on_page(driver)) >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def process_inspection(driver, inspection): >> "%SCRIPT_FILE%"
echo     """Process a single inspection""" >> "%SCRIPT_FILE%"
echo     try: >> "%SCRIPT_FILE%"
echo         log_to_file(f'  Processing: {inspection["name"][:50]} (ID: {inspection["id"][:8]}...)') >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Navigate to inspection page >> "%SCRIPT_FILE%"
echo         driver.get(inspection['url']) >> "%SCRIPT_FILE%"
echo         random_wait() >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Get page text >> "%SCRIPT_FILE%"
echo         try: >> "%SCRIPT_FILE%"
echo             page_text = driver.find_element(By.TAG_NAME, 'body').text >> "%SCRIPT_FILE%"
echo         except: >> "%SCRIPT_FILE%"
echo             page_text = "" >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Build and navigate to PDF URL >> "%SCRIPT_FILE%"
echo         pdf_url = f'https://inspections.myhealthdepartment.com/san-francisco/print/?task=getPrintable^&path=san-francisco^&pKey={inspection["id"]},{inspection["id"]}' >> "%SCRIPT_FILE%"
echo         pdf_path = os.path.join(TEMP_DIR, f'{inspection["id"]}.pdf') >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         driver.get(pdf_url) >> "%SCRIPT_FILE%"
echo         time.sleep(random.uniform(4, 7))  # Longer wait for PDF download >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Check for downloaded PDF >> "%SCRIPT_FILE%"
echo         temp_pdf = os.path.join(TEMP_DIR, 'download.pdf') >> "%SCRIPT_FILE%"
echo         pdf_downloaded = False >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         if os.path.exists(temp_pdf): >> "%SCRIPT_FILE%"
echo             os.rename(temp_pdf, pdf_path) >> "%SCRIPT_FILE%"
echo             pdf_downloaded = True >> "%SCRIPT_FILE%"
echo         else: >> "%SCRIPT_FILE%"
echo             import glob >> "%SCRIPT_FILE%"
echo             pdf_files = glob.glob(os.path.join(TEMP_DIR, '*.pdf')) >> "%SCRIPT_FILE%"
echo             for pdf_file in pdf_files: >> "%SCRIPT_FILE%"
echo                 if inspection['id'] not in pdf_file: >> "%SCRIPT_FILE%"
echo                     os.rename(pdf_file, pdf_path) >> "%SCRIPT_FILE%"
echo                     pdf_downloaded = True >> "%SCRIPT_FILE%"
echo                     break >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         if not pdf_downloaded: >> "%SCRIPT_FILE%"
echo             log_to_file(f'    PDF download failed') >> "%SCRIPT_FILE%"
echo             return False >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Prepare data >> "%SCRIPT_FILE%"
echo         inspection_data = { >> "%SCRIPT_FILE%"
echo             'id': inspection['id'], >> "%SCRIPT_FILE%"
echo             'name': inspection['name'], >> "%SCRIPT_FILE%"
echo             'url': inspection['url'], >> "%SCRIPT_FILE%"
echo             'page_text': page_text[:10000], >> "%SCRIPT_FILE%"
echo             'collected_at': datetime.now().isoformat() >> "%SCRIPT_FILE%"
echo         } >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Upload to server >> "%SCRIPT_FILE%"
echo         success, message = upload_to_server(inspection_data, pdf_path) >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         if success: >> "%SCRIPT_FILE%"
echo             log_to_file(f'    [SUCCESS] Uploaded successfully') >> "%SCRIPT_FILE%"
echo             try: >> "%SCRIPT_FILE%"
echo                 os.remove(pdf_path) >> "%SCRIPT_FILE%"
echo             except: >> "%SCRIPT_FILE%"
echo                 pass >> "%SCRIPT_FILE%"
echo             return True >> "%SCRIPT_FILE%"
echo         else: >> "%SCRIPT_FILE%"
echo             log_to_file(f'    [FAILED] Upload failed: {message}') >> "%SCRIPT_FILE%"
echo             return False >> "%SCRIPT_FILE%"
echo     except Exception as e: >> "%SCRIPT_FILE%"
echo         log_to_file(f'    [ERROR] {str(e)[:100]}') >> "%SCRIPT_FILE%"
echo         return False >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo def main(): >> "%SCRIPT_FILE%"
echo     """Main collector function""" >> "%SCRIPT_FILE%"
echo     log_to_file('='*50) >> "%SCRIPT_FILE%"
echo     log_to_file('Starting SF Smart Collector') >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Load tracker >> "%SCRIPT_FILE%"
echo     tracker = load_tracker() >> "%SCRIPT_FILE%"
echo     last_id = tracker.get('last_inspection_id') >> "%SCRIPT_FILE%"
echo     is_first_run = not bool(last_id) >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     if last_id: >> "%SCRIPT_FILE%"
echo         log_to_file(f'Last processed: {tracker.get("last_facility", "Unknown")[:30]} (ID: {last_id[:8]}...)') >> "%SCRIPT_FILE%"
echo     else: >> "%SCRIPT_FILE%"
echo         log_to_file('First run - no previous inspections tracked') >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Setup Chrome >> "%SCRIPT_FILE%"
echo     log_to_file('Starting Chrome browser...') >> "%SCRIPT_FILE%"
echo     options = Options() >> "%SCRIPT_FILE%"
echo     options.add_argument('--log-level=3') >> "%SCRIPT_FILE%"
echo     options.add_argument('--disable-logging') >> "%SCRIPT_FILE%"
echo     options.add_experimental_option('excludeSwitches', ['enable-logging']) >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     prefs = { >> "%SCRIPT_FILE%"
echo         'download.default_directory': TEMP_DIR, >> "%SCRIPT_FILE%"
echo         'download.prompt_for_download': False, >> "%SCRIPT_FILE%"
echo         'download.directory_upgrade': True, >> "%SCRIPT_FILE%"
echo         'plugins.always_open_pdf_externally': True, >> "%SCRIPT_FILE%"
echo         'safebrowsing.enabled': False >> "%SCRIPT_FILE%"
echo     } >> "%SCRIPT_FILE%"
echo     options.add_experimental_option('prefs', prefs) >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     try: >> "%SCRIPT_FILE%"
echo         service = Service(ChromeDriverManager().install()) >> "%SCRIPT_FILE%"
echo         service.log_path = os.devnull >> "%SCRIPT_FILE%"
echo         driver = webdriver.Chrome(service=service, options=options) >> "%SCRIPT_FILE%"
echo         driver.execute_cdp_cmd('Page.setDownloadBehavior', { >> "%SCRIPT_FILE%"
echo             'behavior': 'allow', >> "%SCRIPT_FILE%"
echo             'downloadPath': TEMP_DIR >> "%SCRIPT_FILE%"
echo         }) >> "%SCRIPT_FILE%"
echo     except Exception as e: >> "%SCRIPT_FILE%"
echo         log_to_file(f'ERROR: Failed to start Chrome: {e}') >> "%SCRIPT_FILE%"
echo         return >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Navigate to site >> "%SCRIPT_FILE%"
echo     log_to_file('Accessing SF inspection site...') >> "%SCRIPT_FILE%"
echo     driver.get('https://inspections.myhealthdepartment.com/san-francisco') >> "%SCRIPT_FILE%"
echo     random_wait() >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     if '403' in driver.title: >> "%SCRIPT_FILE%"
echo         log_to_file('ERROR: Site blocked access (403 Forbidden)') >> "%SCRIPT_FILE%"
echo         driver.quit() >> "%SCRIPT_FILE%"
echo         return >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     log_to_file('Site accessed successfully!') >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Find new inspections >> "%SCRIPT_FILE%"
echo     log_to_file('Searching for new inspections...') >> "%SCRIPT_FILE%"
echo     new_inspections, position = find_last_inspection(driver, last_id, is_first_run) >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     if not new_inspections: >> "%SCRIPT_FILE%"
echo         log_to_file('No new inspections found') >> "%SCRIPT_FILE%"
echo         driver.quit() >> "%SCRIPT_FILE%"
echo         return >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     log_to_file(f'Found {len(new_inspections)} new inspections to process') >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Process from oldest to newest (reverse order) >> "%SCRIPT_FILE%"
echo     new_inspections.reverse() >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Limit to MAX_PER_RUN >> "%SCRIPT_FILE%"
echo     to_process = new_inspections[:MAX_PER_RUN] >> "%SCRIPT_FILE%"
echo     log_to_file(f'Processing {len(to_process)} inspections (max {MAX_PER_RUN} per run)') >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     processed = 0 >> "%SCRIPT_FILE%"
echo     for inspection in to_process: >> "%SCRIPT_FILE%"
echo         if process_inspection(driver, inspection): >> "%SCRIPT_FILE%"
echo             processed += 1 >> "%SCRIPT_FILE%"
echo             # Update tracker with this inspection >> "%SCRIPT_FILE%"
echo             tracker['last_inspection_id'] = inspection['id'] >> "%SCRIPT_FILE%"
echo             tracker['last_facility'] = inspection['name'] >> "%SCRIPT_FILE%"
echo             tracker['last_run'] = datetime.now().isoformat() >> "%SCRIPT_FILE%"
echo             tracker['total_processed'] = tracker.get('total_processed', 0) + 1 >> "%SCRIPT_FILE%"
echo             save_tracker(tracker) >> "%SCRIPT_FILE%"
echo         # >> "%SCRIPT_FILE%"
echo         # Return to main page for next inspection >> "%SCRIPT_FILE%"
echo         driver.get('https://inspections.myhealthdepartment.com/san-francisco') >> "%SCRIPT_FILE%"
echo         random_wait() >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Clean up >> "%SCRIPT_FILE%"
echo     driver.quit() >> "%SCRIPT_FILE%"
echo     # >> "%SCRIPT_FILE%"
echo     # Summary >> "%SCRIPT_FILE%"
echo     log_to_file('-'*50) >> "%SCRIPT_FILE%"
echo     log_to_file(f'Run complete: {processed}/{len(to_process)} uploaded') >> "%SCRIPT_FILE%"
echo     if len(new_inspections) ^> MAX_PER_RUN: >> "%SCRIPT_FILE%"
echo         log_to_file(f'Note: {len(new_inspections) - MAX_PER_RUN} inspections remaining for next run') >> "%SCRIPT_FILE%"
echo     log_to_file(f'Total all-time: {tracker.get("total_processed", 0)} inspections') >> "%SCRIPT_FILE%"
echo     log_to_file('='*50) >> "%SCRIPT_FILE%"
echo # >> "%SCRIPT_FILE%"
echo if __name__ == '__main__': >> "%SCRIPT_FILE%"
echo     try: >> "%SCRIPT_FILE%"
echo         main() >> "%SCRIPT_FILE%"
echo     except Exception as e: >> "%SCRIPT_FILE%"
echo         print(f'CRITICAL ERROR: {e}') >> "%SCRIPT_FILE%"
echo         print(traceback.format_exc()) >> "%SCRIPT_FILE%"

echo Script created successfully!
echo.

REM Install required packages
echo Installing required Python packages...
"%PYTHON_EXE%" -m pip install selenium requests webdriver-manager >nul 2>&1
if %errorlevel% neq 0 (
    echo Installing with output...
    "%PYTHON_EXE%" -m pip install selenium requests webdriver-manager
)
echo.

REM Create a batch file for manual runs
echo Creating manual run shortcut...
(
echo @echo off
echo title SF Smart Collector - Manual Run
echo cd /d "%INSTALL_DIR%"
echo "%PYTHON_EXE%" "%SCRIPT_FILE%"
echo pause
) > "%USERPROFILE%\Desktop\SF_Smart_Manual.bat"

REM Create scheduled tasks for 6 times daily
echo ============================================
echo   SETTING UP AUTOMATED SCHEDULING
echo   Runs 6 times daily (every 4 hours)
echo ============================================
echo.

REM Create 6 daily tasks
echo Creating schedule for 12:00 AM (midnight)...
schtasks /create /tn "SF_Smart_Collector_12AM" /tr "\"%PYTHON_EXE%\" \"%SCRIPT_FILE%\"" /sc daily /st 00:00 /f >nul 2>&1
if %errorlevel% equ 0 echo   [OK] 12:00 AM scheduled

echo Creating schedule for 4:00 AM...
schtasks /create /tn "SF_Smart_Collector_4AM" /tr "\"%PYTHON_EXE%\" \"%SCRIPT_FILE%\"" /sc daily /st 04:00 /f >nul 2>&1
if %errorlevel% equ 0 echo   [OK] 4:00 AM scheduled

echo Creating schedule for 8:00 AM...
schtasks /create /tn "SF_Smart_Collector_8AM" /tr "\"%PYTHON_EXE%\" \"%SCRIPT_FILE%\"" /sc daily /st 08:00 /f >nul 2>&1
if %errorlevel% equ 0 echo   [OK] 8:00 AM scheduled

echo Creating schedule for 12:00 PM (noon)...
schtasks /create /tn "SF_Smart_Collector_12PM" /tr "\"%PYTHON_EXE%\" \"%SCRIPT_FILE%\"" /sc daily /st 12:00 /f >nul 2>&1
if %errorlevel% equ 0 echo   [OK] 12:00 PM scheduled

echo Creating schedule for 4:00 PM...
schtasks /create /tn "SF_Smart_Collector_4PM" /tr "\"%PYTHON_EXE%\" \"%SCRIPT_FILE%\"" /sc daily /st 16:00 /f >nul 2>&1
if %errorlevel% equ 0 echo   [OK] 4:00 PM scheduled

echo Creating schedule for 8:00 PM...
schtasks /create /tn "SF_Smart_Collector_8PM" /tr "\"%PYTHON_EXE%\" \"%SCRIPT_FILE%\"" /sc daily /st 20:00 /f >nul 2>&1
if %errorlevel% equ 0 echo   [OK] 8:00 PM scheduled

echo.
echo ============================================
echo   FRESH INSTALLATION COMPLETE!
echo ============================================
echo.
echo [OK] Old tasks removed
echo [OK] Smart collector installed
echo [OK] 6 daily runs scheduled (every 4 hours)
echo [OK] Manual shortcut: Desktop\SF_Smart_Manual.bat
echo.
echo FEATURES:
echo   - Searches for last known inspection
echo   - Clicks "Show More" until found
echo   - Processes up to 10 per run
echo   - Works from oldest to newest
echo   - Detailed logging of each upload
echo.
echo SCHEDULE:
echo   12:00 AM, 4:00 AM, 8:00 AM
echo   12:00 PM, 4:00 PM, 8:00 PM
echo.
echo FILES:
echo   Installation: %INSTALL_DIR%
echo   Tracking: %TRACKER_FILE%
echo   Logs: %RUN_LOG%
echo.
echo Run initial collection now? (Y/N)
set /p RUN_NOW=
if /i "%RUN_NOW%"=="Y" (
    echo.
    echo Starting initial collection...
    cd /d "%INSTALL_DIR%"
    "%PYTHON_EXE%" "%SCRIPT_FILE%"
)

echo.
echo All done! Press any key to exit...
pause