<!-- Tightened Hero Section with Simplified Search -->
<section class="directory-section" aria-labelledby="directoryTitle">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 col-md-11 mx-auto">
                <!-- Directory Content - Tightened -->
                <div class="directory-content">
                    <h1 id="directoryTitle" class="mb-2">Recovery Resource Directory</h1>
                    <p class="text-muted" id="lcp-element">Over 20,000 facilities covering all 50 states</p>
                    
                    <!-- Simplified Search Card -->
                    <div class="search-card">
                        <form action="/search.php" method="get" id="directorySearchForm">
                            <input type="hidden" name="view" value="<?php echo htmlspecialchars($view ?? 'list'); ?>">
                            
                            <!-- Global Search Box -->
                            <div class="global-search-container mb-3">
                                <label for="globalSearchInput" class="form-label text-start">Search the entire database</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-white border-end-0">
                                        <i class="bi bi-search"></i>
                                    </span>
                                    <input type="text" class="form-control border-start-0" 
                                           id="globalSearchInput" name="q"
                                           placeholder="Search for recovery resources..." 
                                           aria-label="Search query">
                                    <button type="submit" class="btn btn-primary px-4">
                                        Search
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Location Options -->
                            <div class="location-filters mb-3">
                                <div class="row g-3">
                                    <!-- Location -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="locationInput">Location</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-white border-end-0">
                                                    <i class="bi bi-geo-alt"></i>
                                                </span>
                                                <input type="text" class="form-control border-start-0" id="locationInput" 
                                                       name="location" placeholder="City, state or zip code"
                                                       value="<?php echo htmlspecialchars($location ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Distance -->
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label" for="distanceInput">Distance</label>
                                            <select id="distanceInput" name="radius" class="form-control">
                                                <option value="5" <?php echo ($radius ?? 25) === 5 ? 'selected' : ''; ?>>5 miles</option>
                                                <option value="10" <?php echo ($radius ?? 25) === 10 ? 'selected' : ''; ?>>10 miles</option>
                                                <option value="25" <?php echo ($radius ?? 25) === 25 ? 'selected' : ''; ?> selected>25 miles</option>
                                                <option value="50" <?php echo ($radius ?? 25) === 50 ? 'selected' : ''; ?>>50 miles</option>
                                                <option value="100" <?php echo ($radius ?? 25) === 100 ? 'selected' : ''; ?>>100 miles</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <!-- State -->
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label" for="stateFilter">State</label>
                                            <select id="stateFilter" name="state" class="form-control">
                                                <option value="">All States</option>
                                                <?php foreach ($states ?? [] as $state): ?>
                                                    <option value="<?php echo htmlspecialchars($state['state_code']); ?>" 
                                                            <?php echo ($state_code ?? '') === $state['state_code'] ? 'selected' : ''; ?>>
                                                        <?php echo htmlspecialchars($state['state_name']); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Facility Type Checkboxes -->
                            <div class="facility-type-filters mb-3">
                                <label class="form-label d-block mb-2">Facility Types (select multiple)</label>
                                <div class="facility-type-options">
                                    <div class="row">
                                        <div class="col-md-4 col-sm-6 mb-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="facility_types[]" 
                                                       value="HH" id="typeHH" <?php echo in_array('HH', $selected_types ?? []) ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="typeHH">
                                                    Sober Living Homes
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="facility_types[]" 
                                                       value="SA" id="typeSA" <?php echo in_array('SA', $selected_types ?? []) ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="typeSA">
                                                    Treatment Centers
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="facility_types[]" 
                                                       value="DT" id="typeDT" <?php echo in_array('DT', $selected_types ?? []) ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="typeDT">
                                                    Detox Facilities
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="facility_types[]" 
                                                       value="MH" id="typeMH" <?php echo in_array('MH', $selected_types ?? []) ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="typeMH">
                                                    Mental Health
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="facility_types[]" 
                                                       value="SUMH" id="typeSUMH" <?php echo in_array('SUMH', $selected_types ?? []) ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="typeSUMH">
                                                    Co-occurring Disorders
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6 mb-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="facility_types[]" 
                                                       value="OP" id="typeOP" <?php echo in_array('OP', $selected_types ?? []) ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="typeOP">
                                                    Outpatient Programs
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Search Actions -->
                            <div class="search-actions">
                                <div class="row">
                                    <div class="col-md-6 mb-3 mb-md-0">
                                        <a href="/directory.php" class="btn btn-outline-secondary w-100">
                                            <i class="bi bi-x-circle me-2"></i>Reset
                                        </a>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary w-100">
                                            <i class="bi bi-search me-2"></i>Search
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


