<?php

/**

 * Facility Page Configuration

 * 

 * This file contains configuration and metadata for the facility page.

 */



// Required files for FAQ generation - use require_once to prevent errors if file doesn't exist

if (file_exists(BASE_PATH . '/includes/faq-accordion.php')) {

    require_once(BASE_PATH . '/includes/faq-accordion.php');

}



// Set up base URL for canonical links

$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'];



// The canonical URL must be properly defined before it's used in breadcrumbs

$canonical_url = $base_url . '/facility/' . generate_facility_url($facility);



// Page metadata

$page_title = htmlspecialchars($facility['name']) . " | Recovery Resource | SoberList.org";

$meta_description = !empty($facility['description']) ? 

    htmlspecialchars(substr(strip_tags($facility['description']), 0, 160)) . "..." :

    "Detailed information about " . htmlspecialchars($facility['name']) . " - A recovery resource located in " . htmlspecialchars($facility['city'] . ', ' . $facility['state_code']);



// Page-specific flags

$show_search_form = false;

$show_featured_resources = false;

$is_homepage = false;

$include_directory_css = true; // Include directory CSS for similar facilities



// Google Maps API key - keep inside PHP tags

if (!defined('GOOGLE_MAPS_API_KEY') && defined('MAPS_API_KEY')) {

    define('GOOGLE_MAPS_API_KEY', MAPS_API_KEY);

} elseif (!defined('GOOGLE_MAPS_API_KEY')) {

    // Define with a placeholder - will be replaced with actual API key in production

    define('GOOGLE_MAPS_API_KEY', 'YOUR_GOOGLE_MAPS_API_KEY');

}



// Keywords for SEO based on facility type

$keywords = "recovery resources, addiction treatment, " . htmlspecialchars($facility['name']) . ", " . 

    htmlspecialchars($facility['city']) . ", " . htmlspecialchars($facility['state_code']);



// Add primary photo to facility for schema

$facility['primary_photo'] = $image_info['full_url'];

$facility['image_alt'] = $image_info['alt'];



// Set breadcrumbs for the page

$breadcrumbs = [

    ['title' => 'Home', 'url' => SITE_URL],

    ['title' => 'Directory', 'url' => SITE_URL . '/directory'],

];



// Add state to breadcrumbs if available

if (!empty($facility['state_code'])) {

    $breadcrumbs[] = [

        'title' => $facility['state_name'],

        'url' => SITE_URL . '/directory?state=' . $facility['state_code']

    ];

    

    // Add city to breadcrumbs if available

    if (!empty($facility['city'])) {

        $breadcrumbs[] = [

            'title' => $facility['city'],

            'url' => SITE_URL . '/directory?state=' . $facility['state_code'] . '&city=' . urlencode($facility['city'])

        ];

    }

}



// Add current facility as the last breadcrumb - Using canonical URL properly

$breadcrumbs[] = [

    'title' => $facility['name'], 

    'url' => $canonical_url

];



// Generate schema directly to output buffer

// Will be captured in index.php and placed in the proper location

if (function_exists('generateMetaAndSchema')) {

    generateMetaAndSchema($facility, $care_types, $canonical_url, $image_info, true);

}

?>