<?php
// Frankie's article function to add to functions.php

function getFrankiesArticle() {
    return [
        'id' => '2240447',
        'title' => 'Frankie\'s Fast Food Corner Fails Health Inspection in Roseland',
        'slug' => 'frankies-fast-food-roseland-fail',
        'content' => '<p>A routine health inspection at Frankie\'s Fast Food Corner in Chicago\'s Roseland neighborhood resulted in a failed grade after inspectors documented multiple health code violations at the South Side establishment on November 20, 2018.</p>

        <p>The restaurant, located at 10356 South Corliss Avenue near the intersection with 103rd Street, was cited for <a href="/tag/critical-violations">seven violations</a> during a license inspection conducted by the Chicago Department of Public Health. The establishment, classified as a medium-risk facility, failed to meet several critical safety standards.</p>

        <p>Among the most serious violations, inspectors discovered the facility lacked a <a href="/tag/handwashing-violation">handwashing sink</a> in the rear dishwashing area, a Priority Foundation violation that poses immediate health risks. The restaurant was instructed to install a sink with hot and cold running water, along with soap and paper towel dispensers.</p>

        <hr>

        <p>The inspection also revealed the kitchen operated without a ventilation hood over the stove in the rear cooking area. Proper ventilation is essential for removing smoke, grease, and heat from commercial kitchens, and its absence can create hazardous working conditions.</p>

        <p>Inspectors noted the restaurant lacked several critical management policies and equipment. No employee health policy was available on-site, nor was there a documented procedure for responding to vomiting and diarrheal events—both <a href="/tag/priority-foundation">Priority Foundation violations</a> that could lead to foodborne illness outbreaks if not properly addressed.</p>

        <p>The facility was operating without food handler training documentation for any employees, a requirement under Chicago health codes. The absence of basic monitoring equipment, including metal stem thermometers and chemical test kits for dishwashing operations, further compounded the violations.</p>

        <p>Frankie\'s Fast Food Corner serves the <a href="/tag/roseland">Roseland community</a>, a historic neighborhood on Chicago\'s far South Side. The area, accessible via the CTA\'s 103rd Street/Roseland station on the Electric District line, has seen various development initiatives in recent years. The restaurant sits just blocks from Fernwood Park and serves a diverse residential community.</p>',
        
        'meta_title' => 'Frankie\'s Fast Food Corner Fails Health Inspection in Roseland - CleanKitchens',
        'meta_description' => 'South Side restaurant Frankie\'s Fast Food Corner on Corliss Avenue failed health inspection citing multiple violations including missing handwashing facilities and inadequate ventilation.',
        'og_title' => 'Frankie\'s Fast Food Corner Fails Health Inspection',
        'og_description' => 'Roseland restaurant cited for multiple health code violations including missing handwashing sink.',
        'city' => 'Chicago',
        'state' => 'IL',
        'published_date' => '2018-11-20 00:00:00',
        'image_url' => '/assets/images/violations/general_2.jpg',
        'latitude' => 41.70574203912544,
        'longitude' => -87.60410938051729,
        'establishment_name' => 'Frankie\'s Fast Food Corner',
        'tags' => ['Chicago', 'Roseland', 'Failed Inspection', 'Handwashing Violation', 'Ventilation Violation', 'Priority Foundation'],
        'schema_json' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'NewsArticle',
            'headline' => 'Frankie\'s Fast Food Corner Fails Health Inspection in Roseland',
            'description' => 'South Side restaurant failed inspection due to missing handwashing sink and ventilation hood violations',
            'image' => 'http://160.153.178.131/assets/images/violations/general_2.jpg',
            'datePublished' => '2018-11-20T00:00:00-06:00',
            'dateModified' => '2018-11-20T00:00:00-06:00',
            'author' => [
                '@type' => 'Organization',
                'name' => 'CleanKitchens Editorial Team'
            ],
            'publisher' => [
                '@type' => 'Organization',
                'name' => 'CleanKitchens',
                'logo' => [
                    '@type' => 'ImageObject',
                    'url' => 'http://160.153.178.131/logo.png'
                ]
            ]
        ])
    ];
}

function getFrankiesRelatedArticles() {
    return [
        [
            'title' => 'South Side Restaurants Face Increased Health Scrutiny',
            'slug' => 'south-side-health-scrutiny',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-2 days'))
        ],
        [
            'title' => 'Handwashing Violations Rise in Chicago Restaurants',
            'slug' => 'handwashing-violations-chicago',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-1 week'))
        ],
        [
            'title' => 'Roseland Business Development Updates',
            'slug' => 'roseland-business-updates',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-2 weeks'))
        ]
    ];
}