<?php
// Functions that connect to Weaviate and use image selector

function getArticleFromWeaviate($slug) {
    // This would query Weaviate for the article by slug
    // For now, return test data with selected image
    
    // Example of what would come from Weaviate
    $article_data = [
        'title' => 'Frankie\'s Fast Food Corner Fails Health Inspection in Roseland',
        'slug' => 'frankies-fast-food-roseland-fail',
        'content' => '<p>A routine health inspection at Frankie\'s Fast Food Corner...</p>',
        'city' => 'Chicago',
        'state' => 'IL',
        'establishment_name' => 'Frankie\'s Fast Food Corner',
        'published_date' => '2018-11-20 00:00:00',
        'tags' => ['Chicago', 'Roseland', 'Handwashing Violation'],
        'image_url' => '/assets/images/violations/cleanliness_1.jpg', // Selected by image_selector.py
        'image_alt' => 'Restaurant health violation - cleanliness',
        'meta_description' => 'South Side restaurant failed inspection citing violations'
    ];
    
    return $article_data;
}

function getFeaturedArticleFromDB() {
    // Query Weaviate for highest scoring recent article
    // For now, use test data
    
    return [
        'title' => 'Major Chain Restaurant Closed for Rodent Activity',
        'excerpt' => 'Health inspectors found evidence of rodent infestation...',
        'city' => 'Chicago',
        'state' => 'IL',
        'published_date' => date('Y-m-d H:i:s', strtotime('-2 hours')),
        'slug' => 'chain-restaurant-rodent-closure',
        'image_url' => '/assets/images/violations/rodent_1.jpg'
    ];
}

function getRecentClosuresFromDB() {
    // Query Weaviate for is_closure=true articles
    // For now, return test data with real images
    
    return [
        [
            'title' => 'Downtown Restaurant Closed After Failed Inspection',
            'excerpt' => 'Multiple critical violations led to immediate closure...',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-5 hours')),
            'slug' => 'downtown-closure',
            'image_url' => '/assets/images/violations/closure_1.jpg'
        ],
        [
            'title' => 'Popular Pizza Place Shut Down for Temperature Violations',
            'excerpt' => 'Improper food storage temperatures forced closure...',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-1 day')),
            'slug' => 'pizza-temperature-closure',
            'image_url' => '/assets/images/violations/temperature_1.jpg'
        ],
        [
            'title' => 'Coffee Shop Closed Due to Pest Activity',
            'excerpt' => 'Roach infestation discovered during routine inspection...',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-2 days')),
            'slug' => 'coffee-shop-pest-closure',
            'image_url' => '/assets/images/violations/roach_1.jpg'
        ]
    ];
}

function getWeeklyArticlesFromDB() {
    // Query Weaviate for recent articles
    // Return with appropriate images
    
    return [
        [
            'title' => 'Weekly Inspection Report: 23 Violations Found',
            'excerpt' => 'This week\'s inspections revealed concerning trends...',
            'city' => 'Chicago',
            'state' => 'IL',
            'meta_label' => 'Weekly Report',
            'slug' => 'weekly-report-' . date('Y-m-d'),
            'image_url' => '/assets/images/summaries/weekly_summary_1.jpg'
        ],
        [
            'title' => 'Fast Food Chains Show Improvement',
            'excerpt' => 'Major chains demonstrate better compliance...',
            'city' => 'Chicago',
            'state' => 'IL',
            'meta_label' => 'Analysis',
            'slug' => 'chains-improvement-analysis',
            'image_url' => '/assets/images/chains/burger_chain_1.jpg'
        ],
        [
            'title' => 'Health Department Increases Inspections',
            'excerpt' => 'Response to recent outbreak concerns...',
            'city' => 'Chicago',
            'state' => 'IL',
            'meta_label' => 'News',
            'slug' => 'increased-inspections',
            'image_url' => '/assets/images/summaries/daily_summary_1.jpg'
        ]
    ];
}