<?php
// Clean, minimal text-based image generator

// Get format parameter (webp for pages, jpg for social)
$format = $_GET['format'] ?? 'jpg';

// Get parameters
$restaurant = $_GET['restaurant'] ?? 'Restaurant';
$type = $_GET['type'] ?? 'inspection';

// Truncate restaurant name if too long
if (strlen($restaurant) > 25) {
    $restaurant = substr($restaurant, 0, 25) . '...';
}

// Create image
$width = 1200;
$height = 630;
$image = imagecreatetruecolor($width, $height);

// Define colors based on inspection result (just background colors now)
$colors = [
    'fail' => '#DC2626',      // Red
    'pass' => '#16A34A',      // Green  
    'warning' => '#EA580C',   // Orange
    'closure' => '#1E293B',   // Dark gray
    'inspection' => '#4F46E5' // Indigo (default)
];

$bgColorHex = $colors[$type] ?? $colors['inspection'];

// Create colors
$bgColor = imagecolorallocate($image, 
    hexdec(substr($bgColorHex, 1, 2)),
    hexdec(substr($bgColorHex, 3, 2)), 
    hexdec(substr($bgColorHex, 5, 2))
);
$white = imagecolorallocate($image, 255, 255, 255);
$black = imagecolorallocate($image, 0, 0, 0);
$gray = imagecolorallocate($image, 200, 200, 200);

// Fill background
imagefilledrectangle($image, 0, 0, $width, $height, $bgColor);

// Check for TrueType font support
$fontPath = '/usr/share/fonts/truetype/liberation/LiberationSans-Bold.ttf';
$useFont = file_exists($fontPath);

if ($useFont) {
    // Restaurant name - HUGE and centered
    $restaurantSize = 72;
    $restaurantText = strtoupper($restaurant);
    
    // Calculate text dimensions for centering
    $bbox = imagettfbbox($restaurantSize, 0, $fontPath, $restaurantText);
    $textWidth = $bbox[2] - $bbox[0];
    $textHeight = $bbox[1] - $bbox[7];
    
    // If text is too wide, reduce font size
    while ($textWidth > $width - 100 && $restaurantSize > 40) {
        $restaurantSize -= 4;
        $bbox = imagettfbbox($restaurantSize, 0, $fontPath, $restaurantText);
        $textWidth = $bbox[2] - $bbox[0];
    }
    
    $x = ($width - $textWidth) / 2;
    $y = ($height / 2) - 50;
    
    // Add slight shadow for depth
    imagettftext($image, $restaurantSize, 0, $x + 3, $y + 3, $black, $fontPath, $restaurantText);
    imagettftext($image, $restaurantSize, 0, $x, $y, $white, $fontPath, $restaurantText);
    
    // Result text - always "INSPECTION REPORT"
    $resultSize = 48;
    $resultText = 'INSPECTION REPORT';
    
    $bbox = imagettfbbox($resultSize, 0, $fontPath, $resultText);
    $textWidth = $bbox[2] - $bbox[0];
    $x = ($width - $textWidth) / 2;
    $y = ($height / 2) + 80;
    
    imagettftext($image, $resultSize, 0, $x, $y, $white, $fontPath, $resultText);
    
    // Small footer
    $footerText = 'Chicago Health Department';
    $footerSize = 16;
    $bbox = imagettfbbox($footerSize, 0, $fontPath, $footerText);
    $textWidth = $bbox[2] - $bbox[0];
    $x = ($width - $textWidth) / 2;
    $y = $height - 40;
    
    imagettftext($image, $footerSize, 0, $x, $y, $gray, $fontPath, $footerText);
    
} else {
    // Fallback with built-in fonts (less pretty but functional)
    
    // Restaurant name - as large as possible
    $restaurantText = strtoupper($restaurant);
    $font = 5; // Largest built-in font
    
    // Center the text
    $textWidth = imagefontwidth($font) * strlen($restaurantText);
    $x = ($width - $textWidth) / 2;
    $y = ($height / 2) - 60;
    
    // Draw with slight offset for shadow effect
    imagestring($image, $font, $x + 2, $y + 2, $restaurantText, $black);
    imagestring($image, $font, $x, $y, $restaurantText, $white);
    
    // Result text - always "INSPECTION REPORT"
    $resultText = 'INSPECTION REPORT';
    $textWidth = imagefontwidth($font) * strlen($resultText);
    $x = ($width - $textWidth) / 2;
    $y = ($height / 2) + 20;
    
    imagestring($image, $font, $x, $y, $resultText, $white);
    
    // Footer
    $footerText = 'Chicago Health Department';
    $font = 3;
    $textWidth = imagefontwidth($font) * strlen($footerText);
    $x = ($width - $textWidth) / 2;
    $y = $height - 60;
    
    imagestring($image, $font, $x, $y, $footerText, $gray);
}

// Output image in requested format
if ($format === 'webp') {
    header('Content-Type: image/webp');
    imagewebp($image, null, 85);
} else {
    header('Content-Type: image/jpeg');
    imagejpeg($image, null, 90);
}

imagedestroy($image);
?>