<?php

/**

 * Home Page Template - Fully Optimized for Performance

 */



// Include header (which loads config.php and home.php)

include(BASE_PATH . '/app/Views/components/header.php');

?>



<!-- Optimized for minimal LCP and render blocking -->

<div class="container">

    <div class="row">

        <div class="col-lg-8 col-md-10 mx-auto">

            <!-- Above-the-fold content with inline styles -->

            <div style="min-height:500px;padding-top:20px;"> <!-- Generous height reservation for all above-fold content -->

                <!-- First priority content -->

             <h1 style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:2.5rem;font-weight:500;line-height:1.2;text-align:center;margin:20px auto 24px;padding:0;color:#212529;max-width:100%;display:block;border:none;background:none;">America's Largest Recovery Resource Directory</h1>





                

                <p id="lcp-element" style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:1.25rem;font-weight:400;line-height:1.5;text-align:center;margin:0 auto 2rem;max-width:800px;color:#212529;">

                    Find verified sober living homes, detox facilities, treatment centers, and mental health resources nationwide.

                </p>

                

                <!-- Second priority content -->

                <div style="margin-bottom:2rem;text-align:center;">

                    <h2 style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:2rem;font-weight:500;line-height:1.3;text-align:center;margin:0 0 1.5rem;color:#212529;">Recovery Resources Nationwide</h2>

                    <div style="display:flex;justify-content:center;gap:2rem;margin-top:1rem;">

                        <div style="text-align:center;min-width:120px;">

                            <div style="font-size:2.5rem;font-weight:700;color:#0d6efd;line-height:1.2;"><?= number_format($total_resources); ?> +</div>

                            <div style="font-size:1rem;color:#212529;">Total Resources</div>

                        </div>

                    </div>

                </div>

                

                <!-- Third priority content -->

                <h2 style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:2rem;font-weight:500;line-height:1.3;text-align:center;margin:2rem 0 1rem;color:#212529;">Transforming Recovery Access</h2>

                <p style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:1rem;font-weight:400;line-height:1.5;text-align:center;margin:0 auto 2rem;max-width:800px;color:#212529;">

                    At SoberList, we're building more than just a directory—we're creating a comprehensive platform to connect the recovery community and streamline access to life-saving resources.

                </p>

            </div>

            

            <!-- Below-the-fold content - no need for inline optimization -->

            <div>

                <!-- Feature Cards Section -->

                <div class="feature-cards">

                    <div class="row">

                        <div class="col-md-6 mb-4">

                            <div class="feature-card p-4 bg-accessible-light rounded">

                                <h3>For Facility Providers</h3>

                                <p class="text-accessible-on-light">We're introducing the ability for facility owners and managers to claim and manage their listings. Soon you'll be able to:</p>

                                <ul class="list-disc text-accessible-on-light">

                                    <li>Verify and update your facility information</li>

                                    <li>Showcase your facility's unique services</li>

                                    <li>Manage real-time bed availability updates</li>

                                    <li>Respond to inquiries directly through our platform</li>

                                    <li>Streamline your waitlist management process</li>

                                </ul>

                                

                            </div>

                        </div>

                        

                        <div class="col-md-6 mb-4">

                            <div class="feature-card p-4 bg-accessible-light rounded">

                                <h3>For Individuals Seeking Help</h3>

                                <p class="text-accessible-on-light">We're expanding our platform to make finding and accessing help easier than ever. Soon you'll be able to:</p>

                                <ul class="list-disc text-accessible-on-light">

                                    <li>View real-time bed availability at facilities</li>

                                    <li>Join facility waitlists with a single click</li>

                                    <li>Apply directly to facilities with open beds</li>

                                    <li>Receive notifications when beds become available</li>

                                    <li>Save your information for faster applications</li>

                                </ul>

                               

                            </div>

                        </div>

                    </div>

                </div>

                

                <!-- Community Features Coming Soon -->

                <div class="community-section mb-5">

                    <h2 class="text-center mb-4">Building a Connected Recovery Community</h2>

                    <p class="text-center mb-4 text-accessible-on-light">Recovery thrives through connection. Our upcoming community features will help strengthen the recovery network nationwide.</p>

                    

                    <div class="row">

                        <div class="col-md-4 mb-4">

                            <div class="community-card text-center p-4 bg-accessible-light rounded h-100">

                                <div class="icon-container mb-3">

                                    <i class="bi bi-calendar-check fs-2 text-primary"></i>

                                </div>

                                <h3>Meeting Finder & Creator</h3>

                                <p class="text-accessible-on-light">Create, discover, and join AA/NA meetings in your area. Set up recurring meetings and manage attendance with ease.</p>

                                <div class="coming-soon-container">

                                    <span class="coming-soon-badge">Coming Summer 2025</span>

                                </div>

                            </div>

                        </div>

                        

                        <div class="col-md-4 mb-4">

                            <div class="community-card text-center p-4 bg-accessible-light rounded h-100">

                                <div class="icon-container mb-3">

                                    <i class="bi bi-people fs-2 text-primary"></i>

                                </div>

                                <h3>Online Recovery Groups</h3>

                                <p class="text-accessible-on-light">Create and join local online recovery communities. Share experiences, offer support, and build connections in a safe environment.</p>

                                <div class="coming-soon-container">

                                    <span class="coming-soon-badge">Coming Fall 2025</span>

                                </div>

                            </div>

                        </div>

                        

                        <div class="col-md-4 mb-4">

                            <div class="community-card text-center p-4 bg-accessible-light rounded h-100">

                                <div class="icon-container mb-3">

                                    <i class="bi bi-chat-dots fs-2 text-primary"></i>

                                </div>

                                <h3>Resource Matching</h3>

                                <p class="text-accessible-on-light">Our intelligent matching system will connect you with the most suitable resources based on your specific needs and preferences.</p>

                                <div class="coming-soon-container">

                                    <span class="coming-soon-badge">Coming Winter 2025</span>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

                

             

                

          

     

                

                <!-- Mission Statement -->

                <div class="mission-section mb-5">

                    <h2 class="text-center mb-4">Our Mission</h2>

                    <p class="text-accessible-on-light">At SoberList, we believe recovery should be accessible to everyone. Our mission is to break down barriers to treatment and support by connecting individuals with the resources they need, when they need them most. Through technology and community, we're building a more connected, supportive recovery ecosystem across America.</p>

                </div>

            </div>

        </div>

    </div>

</div>



<?php

// Include footer

include(BASE_PATH . '/app/Views/components/footer.php');

?>



<!-- Performance optimization script -->

<script>

document.addEventListener('DOMContentLoaded', function() {

    // Create an intersection observer for lazy loading images and content

    const observer = new IntersectionObserver((entries) => {

        entries.forEach(entry => {

            if (entry.isIntersecting) {

                // If data-src attribute exists, it's an image to lazy load

                if (entry.target.dataset.src) {

                    entry.target.src = entry.target.dataset.src;

                    delete entry.target.dataset.src;

                }

                

                // If this element has deferred content to load

                if (entry.target.dataset.deferredContent) {

                    entry.target.innerHTML = entry.target.dataset.deferredContent;

                    delete entry.target.dataset.deferredContent;

                }

                

                // Stop observing the element once it's been processed

                observer.unobserve(entry.target);

            }

        });

    }, {

        // Start loading when within 100px of viewport

        rootMargin: '100px'

    });

    

    // Force LCP prioritization

    const lcpElement = document.getElementById('lcp-element');

    if (lcpElement) {

        lcpElement.style.contentVisibility = 'visible';

    }

    

    // Prioritize all content in the above-the-fold section

    const aboveTheFold = document.querySelectorAll('.container > .row > div > div:first-child *');

    aboveTheFold.forEach(el => {

        // If it's an image, we could prioritize loading

        if (el.tagName === 'IMG') {

            el.loading = 'eager';

            el.fetchPriority = 'high';

        }

    });

    

    // Flag render completion to browser

    requestAnimationFrame(() => {

        requestAnimationFrame(() => {

            // Mark the page as fully loaded in a dataset

            document.body.dataset.initialRenderComplete = 'true';

            

            // Maybe trigger a paint flush

            document.body.getBoundingClientRect();

        });

    });

});

</script>