<!-- Footer -->
<footer>
    <div class="container">
        <div class="footer-links">
            <a href="/about">About</a>
            <a href="/methodology">Methodology</a>
            <a href="/data-sources.php">Data Sources</a>
            <a href="/editorial-policy">Editorial Policy</a>
            <a href="/contact">Contact</a>
            <a href="/privacy">Privacy</a>
            <a href="/terms">Terms</a>
            <a href="/corrections">Corrections</a>
        </div>
        <p class="footer-copyright">© 2025 CleanKitchens. Data sourced from official health departments. <a href="/disclaimer">Disclaimer</a></p>
    </div>
</footer>

<script>
// Theme management
(function() {
    // Check for saved theme preference or default to 'auto'
    const savedTheme = localStorage.getItem('theme') || 'auto';
    
    // Apply saved theme immediately to prevent flash
    if (savedTheme === 'dark') {
        document.documentElement.classList.add('dark-mode');
    } else if (savedTheme === 'light') {
        document.documentElement.classList.add('light-mode');
    }
    // If 'auto', the CSS media query handles it
})();

function getCurrentThemeIcon() {
    const root = document.documentElement;
    const isDark = root.classList.contains('dark-mode') || 
                  (!root.classList.contains('light-mode') && 
                   window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches);
    return isDark ? '☀️' : '🌙';
}

function updateThemeIcon() {
    const icons = document.querySelectorAll('.theme-icon');
    const newIcon = getCurrentThemeIcon();
    icons.forEach(icon => {
        icon.textContent = newIcon;
    });
}

function toggleTheme() {
    const root = document.documentElement;
    const currentTheme = localStorage.getItem('theme') || 'auto';
    
    if (currentTheme === 'auto') {
        // If auto, check system preference and set opposite
        const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
        if (prefersDark) {
            root.classList.add('light-mode');
            root.classList.remove('dark-mode');
            localStorage.setItem('theme', 'light');
        } else {
            root.classList.add('dark-mode');
            root.classList.remove('light-mode');
            localStorage.setItem('theme', 'dark');
        }
    } else if (currentTheme === 'dark') {
        root.classList.remove('dark-mode');
        root.classList.add('light-mode');
        localStorage.setItem('theme', 'light');
    } else {
        root.classList.remove('light-mode');
        root.classList.add('dark-mode');
        localStorage.setItem('theme', 'dark');
    }
    
    updateThemeIcon();
    
    // Update mobile menu if it exists
    const mobileMenu = document.getElementById('mobileMenu');
    if (mobileMenu) {
        const themeLink = mobileMenu.querySelector('a[onclick*="toggleTheme"]');
        if (themeLink) {
            const icon = themeLink.querySelector('.theme-icon');
            if (icon) icon.textContent = getCurrentThemeIcon();
        }
    }
}

// Update icon on page load
document.addEventListener('DOMContentLoaded', function() {
    updateThemeIcon();
});

// Mobile menu functionality
function toggleMenu() {
    const menu = document.getElementById('mobileMenu');
    const hamburger = document.querySelector('.mobile-menu');
    
    if (!menu) {
        // Create menu if it doesn't exist
        const nav = document.querySelector('.navbar');
        const menuHtml = `
            <div id="mobileMenu" class="mobile-nav-menu">
                <a href="/">Home</a>
                <a href="/topics">Topics</a>
                <a href="/search">Search</a>
                <a href="/about">About</a>
                <a href="#" onclick="toggleTheme(); return false;" style="display: flex; align-items: center; gap: 8px;">
                    <span class="theme-icon">${getCurrentThemeIcon()}</span>
                    <span>Toggle Theme</span>
                </a>
                <div style="padding: 16px; border-top: 1px solid var(--border-color); margin-top: 8px;">
                    <div style="font-size: 12px; color: var(--text-muted); margin-bottom: 12px; text-transform: uppercase; letter-spacing: 0.5px;">Stay Connected</div>
                    <div style="display: flex; gap: 12px; justify-content: center;">
                        <a href="/rss" style="color: var(--text-secondary); font-size: 20px; text-decoration: none;">📡</a>
                        <a href="/newsletter" style="color: var(--text-secondary); font-size: 20px; text-decoration: none;">✉</a>
                    </div>
                </div>
            </div>
        `;
        nav.insertAdjacentHTML('afterend', menuHtml);
        const newMenu = document.getElementById('mobileMenu');
        newMenu.classList.add('active');
        hamburger.classList.add('active');
    } else {
        // Toggle visibility
        menu.classList.toggle('active');
        hamburger.classList.toggle('active');
    }
}

// Set up event listeners when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    // Handle keyboard accessibility
    const hamburger = document.querySelector('.mobile-menu');
    if (hamburger) {
        hamburger.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                toggleMenu();
            }
        });
    }
    
    <?php if ($pageType === 'article'): ?>
    // Track all link clicks on article pages
    document.body.addEventListener('click', function(e) {
        const link = e.target.closest('a');
        if (!link || link.href.startsWith('#')) return;
        
        const isExternal = link.hostname !== window.location.hostname;
        const trackingData = {
            url: link.href,
            text: link.textContent.trim().substring(0, 100),
            type: isExternal ? 'external' : 'internal',
            article_id: document.querySelector('meta[name="article-id"]')?.content || '0'
        };
        
        // Send tracking beacon (doesn't block navigation)
        if (navigator.sendBeacon) {
            navigator.sendBeacon('/track-click.php', JSON.stringify(trackingData));
        }
    });
    <?php endif; ?>
});

// Close menu when clicking outside
document.addEventListener('click', function(e) {
    const menu = document.getElementById('mobileMenu');
    const hamburger = document.querySelector('.mobile-menu');
    if (menu && menu.classList.contains('active') && 
        !menu.contains(e.target) && !hamburger.contains(e.target)) {
        menu.classList.remove('active');
        hamburger.classList.remove('active');
    }
});

<?php if ($pageType === 'article'): ?>
// Share functions
function shareOnFacebook(e) {
    e.preventDefault();
    const url = encodeURIComponent(window.location.href);
    window.open(`https://www.facebook.com/sharer/sharer.php?u=${url}`, '_blank', 'width=600,height=400');
}

function shareOnTwitter(e) {
    e.preventDefault();
    const url = encodeURIComponent(window.location.href);
    const text = encodeURIComponent(document.querySelector('.article-title').textContent);
    window.open(`https://x.com/intent/tweet?url=${url}&text=${text}`, '_blank', 'width=600,height=400');
}

function shareViaEmail(e) {
    e.preventDefault();
    const subject = encodeURIComponent(document.querySelector('.article-title').textContent);
    const body = encodeURIComponent(`Check out this article: ${window.location.href}`);
    window.location.href = `mailto:?subject=${subject}&body=${body}`;
}
<?php endif; ?>

// Lazy load images
if ('IntersectionObserver' in window) {
    const imageObserver = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const img = entry.target;
                if (img.dataset.src) {
                    img.src = img.dataset.src;
                    img.removeAttribute('data-src');
                    imageObserver.unobserve(img);
                }
            }
        });
    });
    
    document.querySelectorAll('img[data-src]').forEach(img => {
        imageObserver.observe(img);
    });
}

// Load ads after page is fully loaded to prevent layout shifts
window.addEventListener('load', function() {
    // Delay ads loading to improve Core Web Vitals
    setTimeout(function() {
        // DNS prefetch for ads
        const prefetchLinks = [
            '//pagead2.googlesyndication.com',
            '//fundingchoicesmessages.google.com'
        ];
        
        prefetchLinks.forEach(function(href) {
            const link = document.createElement('link');
            link.rel = 'dns-prefetch';
            link.href = href;
            document.head.appendChild(link);
        });
        
        // Load ads script
        const adsScript = document.createElement('script');
        adsScript.async = true;
        adsScript.src = 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-5314063124334673';
        adsScript.crossOrigin = 'anonymous';
        document.head.appendChild(adsScript);
    }, 1000); // 1 second delay
});
</script>
</body>
</html>