<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php if ($pageType === 'article'): ?>
        <!-- Article Meta -->
        <title><?= htmlspecialchars($article['meta_title']) ?> - <?= SITE_NAME ?></title>
        <meta name="description" content="<?= htmlspecialchars($article['meta_description']) ?>">
        
        <!-- Enhanced Meta Tags -->
        <meta name="robots" content="index, follow, max-image-preview:large">
        <meta name="googlebot" content="index, follow">
        
        <!-- Generative Engine Optimization (GEO) -->
        <meta name="ai-content-type" content="news-article">
        <meta name="ai-expertise-level" content="authoritative">
        <meta name="content-authenticity" content="human-edited">
        <meta name="data-source" content="government-verified">
        
        <!-- Open Graph (Complete) -->
        <meta property="og:type" content="article">
        <meta property="og:title" content="<?= htmlspecialchars($article['meta_title']) ?>">
        <meta property="og:description" content="<?= htmlspecialchars($article['meta_description']) ?>">
        <meta property="og:image" content="<?= SITE_URL ?><?= getOptimizedImageUrl('', 'og', $article) ?>">
        <meta property="og:url" content="<?= SITE_URL ?>/<?= $article['slug'] ?>">
        <meta property="og:site_name" content="CleanKitchens">
        <meta property="article:published_time" content="<?= $article['published_date'] ?>">
        <meta property="article:author" content="CleanKitchens Editorial Team">
        
        <!-- Twitter Card -->
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:site" content="@cleankitchens">
        <meta name="twitter:title" content="<?= htmlspecialchars($article['meta_title']) ?>">
        <meta name="twitter:description" content="<?= htmlspecialchars($article['meta_description']) ?>">
        <meta name="twitter:image" content="<?= SITE_URL ?><?= getOptimizedImageUrl('', 'twitter', $article) ?>">
        
        <!-- Geographic -->
        <meta name="geo.region" content="US-IL">
        <meta name="geo.placename" content="<?= $article['city'] ?>">
        <meta name="geo.position" content="<?= $article['latitude'] ?>;<?= $article['longitude'] ?>">
        <meta name="ICBM" content="<?= $article['latitude'] ?>, <?= $article['longitude'] ?>">
        
        <!-- Business Context -->
        <meta name="business-name" content="<?= htmlspecialchars($article['establishment_name']) ?>">
        <meta name="inspection-type" content="routine">
        <meta name="violation-severity" content="critical">
        
        <!-- Schema -->
        <?php 
        $schemas = json_decode($article['schema_json'], true);
        if (is_array($schemas) && isset($schemas[0])): 
            foreach ($schemas as $schema):
        ?>
        <script type="application/ld+json">
        <?= json_encode($schema, JSON_UNESCAPED_SLASHES) ?>
        </script>
        <?php 
            endforeach;
        else: 
        ?>
        <script type="application/ld+json">
        <?= $article['schema_json'] ?>
        </script>
        <?php endif; ?>
        
    <?php else: ?>
        <!-- Static/Home Page Meta -->
        <title><?= htmlspecialchars($pageData['title']) ?> - <?= SITE_NAME ?></title>
        <meta name="description" content="<?= htmlspecialchars($pageData['description']) ?>">
        
        <!-- Schema -->
        <script type="application/ld+json">
        <?= $pageData['schema'] ?>
        </script>
    <?php endif; ?>
    
    <!-- Common Meta -->
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="<?= SITE_URL ?><?= $_SERVER['REQUEST_URI'] ?>">
    
    <!-- Performance hints for critical resources only -->
    <link rel="dns-prefetch" href="//fonts.googleapis.com">
    
    <!-- Inline CSS -->
    <style>
        <?php include 'styles.php'; ?>
    </style>
</head>
<body>