<?php
// Pages Meta and Schema Configuration

$pagesConfig = [
    'home' => [
        'title' => 'Restaurant Health Inspection News',
        'description' => 'Breaking news on restaurant health inspections, food safety violations, and establishment closures across major US cities.',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebSite',
            'name' => 'CleanKitchens',
            'description' => 'Real-time restaurant health inspection news and food safety reporting',
            'url' => SITE_URL,
            'potentialAction' => [
                '@type' => 'SearchAction',
                'target' => [
                    '@type' => 'EntryPoint',
                    'urlTemplate' => SITE_URL . '/search?q={search_term_string}'
                ],
                'query-input' => 'required name=search_term_string'
            ]
        ])
    ],
    
    'tags' => [
        'title' => 'Topics - Restaurant Inspection Categories',
        'description' => 'Browse restaurant health inspection news by location, violation type, and restaurant chain.',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'CollectionPage',
            'name' => 'Restaurant Inspection Topics',
            'description' => 'All restaurant health inspection topics and categories',
            'url' => SITE_URL . '/tags'
        ])
    ],
    
    'contact' => [
        'title' => 'Contact Us',
        'description' => 'Get in touch with the CleanKitchens editorial team. Report errors, suggest stories, or provide feedback.',
        'h1' => 'Contact Us',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'ContactPage',
            'name' => 'Contact CleanKitchens',
            'url' => SITE_URL . '/contact'
        ])
    ],
    
    'about' => [
        'title' => 'About CleanKitchens',
        'description' => 'Learn about our mission to provide real-time restaurant health inspection news and our data methodology.',
        'h1' => 'About CleanKitchens',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'AboutPage',
            'name' => 'About CleanKitchens',
            'url' => SITE_URL . '/about'
        ])
    ],
    
    'methodology' => [
        'title' => 'Our Methodology - Data Collection & Processing',
        'description' => 'Learn how CleanKitchens collects, processes, and presents restaurant health inspection data from official government sources.',
        'h1' => 'Our Methodology',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => 'CleanKitchens Methodology',
            'url' => SITE_URL . '/methodology'
        ])
    ],
    
    'editorial-policy' => [
        'title' => 'Editorial Policy - Our Standards',
        'description' => 'CleanKitchens editorial standards for fair, accurate, and responsible reporting of health inspection data.',
        'h1' => 'Editorial Policy',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => 'CleanKitchens Editorial Policy',
            'url' => SITE_URL . '/editorial-policy'
        ])
    ],
    
    'corrections' => [
        'title' => 'Corrections - Accuracy Commitment',
        'description' => 'Report errors and view corrections. CleanKitchens is committed to accuracy in all reporting.',
        'h1' => 'Corrections',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => 'CleanKitchens Corrections',
            'url' => SITE_URL . '/corrections'
        ])
    ],
    
    'disclaimer' => [
        'title' => 'Disclaimer - Important Information',
        'description' => 'Important information about the use of CleanKitchens data and limitations of liability.',
        'h1' => 'Disclaimer',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => 'CleanKitchens Disclaimer',
            'url' => SITE_URL . '/disclaimer'
        ])
    ],
    
    'privacy' => [
        'title' => 'Privacy Policy',
        'description' => 'How CleanKitchens collects, uses, and protects your personal information.',
        'h1' => 'Privacy Policy',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => 'CleanKitchens Privacy Policy',
            'url' => SITE_URL . '/privacy'
        ])
    ],
    
    'terms' => [
        'title' => 'Terms of Service',
        'description' => 'Terms and conditions for using CleanKitchens.org website and services.',
        'h1' => 'Terms of Service',
        'schema' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => 'CleanKitchens Terms of Service',
            'url' => SITE_URL . '/terms'
        ])
    ]
];