<?php
// SIMPLE HOMEPAGE - No routing, just display stories
require_once 'includes/config.php';
require_once 'functions_simple.php';

// Get homepage data
$articles = getHomepageArticles();
$featuredArticle = getFeaturedArticle();

// Set page variables for head.php (keep compatibility)
$pageType = 'home';
$pageData = [
    'title' => 'CleanKitchens - Restaurant Health Inspection News',
    'description' => 'Real-time restaurant health inspection news and food safety reporting'
];

// Create homepage sections for template compatibility
$homepageSections = [
    'recent' => [
        'title' => 'Recent Inspection Reports',
        'articles' => array_slice($articles, 0, 6)
    ]
];
?>
<?php include 'includes/head.php'; ?>
<?php include 'includes/nav.php'; ?>
    
    <main id="main-content">
        <div class="container">
            
            <?php if ($featuredArticle): ?>
            <!-- Featured Article -->
            <article class="featured-article">
                <div class="featured-image">
                    <picture>
                        <source srcset="<?= getImageSrcSet(getArticleImage($featuredArticle)) ?>" 
                                type="image/webp"
                                sizes="(max-width: 768px) 100vw, 66vw">
                        <img src="<?= getOptimizedImageUrl('', 'page', $featuredArticle) ?>" 
                             alt="<?= htmlspecialchars($featuredArticle['establishment_name'] ?? 'Featured article') ?> inspection" 
                             width="800" height="400"
                             loading="eager"
                             fetchpriority="high">
                    </picture>
                </div>
                <div class="featured-content">
                    <span class="featured-badge">Breaking</span>
                    <h2 class="article-title"><?= htmlspecialchars($featuredArticle['title']) ?></h2>
                    <p class="article-meta"><?= htmlspecialchars($featuredArticle['city']) ?>, <?= htmlspecialchars($featuredArticle['state']) ?> • <?= htmlspecialchars($featuredArticle['formatted_time']) ?></p>
                    <p class="article-excerpt"><?= htmlspecialchars($featuredArticle['excerpt']) ?></p>
                    <a href="/<?= htmlspecialchars($featuredArticle['slug']) ?>" class="article-link">Read full story →</a>
                </div>
            </article>
            <?php endif; ?>

            <!-- Recent Articles -->
            <section class="news-section">
                <h2 class="section-title">Recent Inspection Reports</h2>
                <div class="articles-grid">
                    <?php foreach (array_slice($articles, 1, 6) as $article): ?>
                    <article class="article-card">
                        <a href="/<?= htmlspecialchars($article['slug']) ?>" class="article-link">
                            <div class="article-image">
                                <picture>
                                    <source srcset="<?= getImageSrcSet(getArticleImage($article), [300, 400, 600]) ?>" 
                                            type="image/webp"
                                            sizes="(max-width: 768px) 100vw, 33vw">
                                    <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                                         alt="<?= htmlspecialchars($article['establishment_name'] ?? 'Restaurant inspection') ?>"
                                         width="400" height="300"
                                         loading="lazy"
                                         style="width: 100%; height: 100%; object-fit: cover; display: block;">
                                </picture>
                            </div>
                            <div class="article-content">
                                <h3 class="article-title"><?= htmlspecialchars($article['title']) ?></h3>
                                <p class="article-excerpt"><?= htmlspecialchars($article['excerpt']) ?></p>
                                <p class="article-meta"><?= htmlspecialchars($article['city']) ?>, <?= htmlspecialchars($article['state']) ?> • <?= htmlspecialchars($article['formatted_time']) ?></p>
                            </div>
                        </a>
                    </article>
                    <?php endforeach; ?>
                </div>
            </section>
            
        </div>
    </main>
    
    <?php include 'includes/footer.php'; ?>