<?php
require_once 'includes/config.php';
require_once 'includes/pages-meta-schema.php';
require_once 'functions.php';
require_once 'functions_live.php';

// Check if this is an article request
$path = trim($_SERVER['REQUEST_URI'], '/');
$path = parse_url($path, PHP_URL_PATH);

// Remove 'live_test.php' from path if present
$path = str_replace('live_test.php/', '', $path);
$path = str_replace('live_test.php', '', $path);

if (!empty($path) && $path !== 'live_test') {
    // Try to get article by slug
    $article = getArticleBySlugFromDB($path);
    
    if ($article) {
        // Display article
        $pageType = 'article';
        $template = 'article';
        $relatedArticles = getRelatedArticlesFromDB();
        
        // Start output
        include 'includes/head.php';
        include 'includes/nav.php';
        
        // Main content
        echo '<main id="main-content">';
        include "templates/article.php";
        echo '</main>';
        
        include 'includes/footer.php';
        exit;
    }
}

// Homepage with live data
$pageType = 'home';
$template = 'news-layout';
$pageData = $pagesConfig['home'];
$pageTitle = $pageData['title'];
$pageDescription = $pageData['description'];

// Get LIVE articles from Weaviate
$featuredArticle = getFeaturedArticleFromDB();
$recentClosures = getRecentClosuresFromDB();
$weeklyArticles = getWeeklyArticlesFromDB();

// Start output
include 'includes/head.php';
include 'includes/nav.php';

// Main content
echo '<main id="main-content">';
include "templates/news-layout.php";
echo '</main>';

include 'includes/footer.php';
?>