#!/usr/bin/env python3
"""
Test STRICT image generation - NO PEOPLE, NO TEXT
"""

import os
import sys

# Set the API key
os.environ['OPENAI_API_KEY'] = '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'

sys.path.insert(0, '/var/www/twin-digital-media/public_html/_sites/cleankitchens/production/scripts')

from generate_stock_images_v2 import StockImageGenerator

def test_strict_generation():
    """Test with very strict no people/no text prompts"""
    generator = StockImageGenerator()
    generator.create_directories()
    
    print("\n=== Testing STRICT generation - NO PEOPLE, NO TEXT ===")
    
    # Ultra-specific test prompts
    test_prompts = [
        # Rodent - very explicit about no people
        ("Completely empty and deserted industrial kitchen corner at night, mouse droppings visible on concrete floor near stainless steel leg of prep table, single strand of plain yellow caution tape, dramatic overhead lighting casting shadows, photorealistic style, ABSOLUTELY NO PEOPLE, NO HUMAN FIGURES, NO TEXT, NO WRITING", "rodent", 5),
        
        # Closure - no text on notices
        ("Locked glass door of closed restaurant at dusk, red paper rectangle taped to door (completely blank no text), view from outside looking at empty dark interior, photorealistic, NO PEOPLE WHATSOEVER, NO READABLE TEXT OR WRITING", "closure", 5),
        
        # General violation  
        ("Wide angle view of completely abandoned commercial kitchen, plain yellow caution tape stretched across middle of frame, stainless steel surfaces, harsh fluorescent lighting from above, photorealistic, ABSOLUTELY NO HUMAN FIGURES OR SILHOUETTES, NO TEXT OR SIGNS WITH WORDS", "general", 5)
    ]
    
    results = []
    for prompt, category, index in test_prompts:
        print(f"\nGenerating STRICT {category}_{index}...")
        result = generator.generate_image(prompt, category, index)
        if result:
            results.append(result)
            print(f"✓ Generated: {result['filepath']}")
    
    print(f"\n=== Test Complete ===")
    print(f"Generated: {generator.stats['generated']} images")
    print(f"Failed: {generator.stats['failed']} images")
    print(f"Cost: ${generator.stats['total_cost']:.2f}")
    
    return results

if __name__ == "__main__":
    print("Testing STRICT image generation (3 images)")
    print("NO PEOPLE, NO TEXT, NO FOREIGN LANGUAGE")
    print("Cost: ~$0.24")
    response = input("Proceed? (y/n): ")
    
    if response.lower() == 'y':
        test_strict_generation()
    else:
        print("Cancelled")