#!/bin/bash
# Setup cron jobs for automatic sitemap generation

SCRIPT_DIR="/var/www/twin-digital-media/public_html/_sites/cleankitchens/scripts"

echo "Setting up CleanKitchens sitemap generation cron jobs..."

# Create cron entries
CRON_JOBS="
# CleanKitchens Sitemap Generation
# Generate news sitemap every hour for Google News
0 * * * * /usr/bin/php $SCRIPT_DIR/generate_sitemaps.php news >> /var/log/cleankitchens_sitemap.log 2>&1

# Generate recent sitemap every 6 hours
0 */6 * * * /usr/bin/php $SCRIPT_DIR/generate_sitemaps.php recent >> /var/log/cleankitchens_sitemap.log 2>&1

# Generate archive sitemaps weekly (Sunday at 2 AM)
0 2 * * 0 /usr/bin/php $SCRIPT_DIR/generate_sitemaps.php archive >> /var/log/cleankitchens_sitemap.log 2>&1

# Update sitemap index daily at 3 AM
0 3 * * * /usr/bin/php $SCRIPT_DIR/generate_sitemaps.php index >> /var/log/cleankitchens_sitemap.log 2>&1

# Generate pages sitemap weekly (Sunday at 2:30 AM)
30 2 * * 0 /usr/bin/php $SCRIPT_DIR/generate_sitemaps.php pages >> /var/log/cleankitchens_sitemap.log 2>&1
"

# Check if cron jobs already exist
if crontab -l 2>/dev/null | grep -q "CleanKitchens Sitemap Generation"; then
    echo "Cron jobs already exist. Updating..."
    # Remove existing CleanKitchens entries
    crontab -l | grep -v "CleanKitchens" | grep -v "generate_sitemaps.php" | crontab -
fi

# Add new cron jobs
(crontab -l 2>/dev/null; echo "$CRON_JOBS") | crontab -

echo "Cron jobs installed successfully!"
echo ""
echo "Cron schedule:"
echo "- News sitemap: Every hour"
echo "- Recent sitemap: Every 6 hours"
echo "- Archive sitemaps: Weekly (Sundays at 2 AM)"
echo "- Sitemap index: Daily at 3 AM"
echo "- Pages sitemap: Weekly (Sundays at 2:30 AM)"
echo ""
echo "Logs will be written to: /var/log/cleankitchens_sitemap.log"
echo ""
echo "To view current cron jobs: crontab -l"
echo "To view logs: tail -f /var/log/cleankitchens_sitemap.log"