<?php

/**

 * Search Page Template - SoberList.org

 * Optimized for performance with minimal render-blocking

 */



// Include header (which loads config.php and search.php)

include(BASE_PATH . '/app/Views/components/header.php');

?>



<!-- Search Hero Section with Form -->

<section class="search-hero" aria-labelledby="searchTitle">

    <div class="hero-bg">

        <div class="container">

            <div class="hero-content">

                <!-- Above-the-fold content with inline styles for LCP optimization -->

                <h1 id="searchTitle" style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:2.5rem;font-weight:500;line-height:1.2;text-align:center;margin:20px auto 24px;padding:0;color:#ffffff;max-width:100%;display:block;border:none;background:none;">Search Recovery Resources</h1>

                

                <p id="lcp-element" style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:1.25rem;font-weight:400;line-height:1.5;text-align:center;margin:0 auto 2rem;max-width:800px;color:#ffffff;">

                    Find support tailored to your needs across our nationwide database

                </p>

                

                <!-- Search Form Card -->

                <div class="search-card">

                    <form action="/search" method="get" id="searchForm">

                        <input type="hidden" name="view" value="<?php echo htmlspecialchars($view); ?>">

                        

                        <!-- Main Search Inputs -->

                        <div class="search-form-main">

                            <div class="search-row">

                                <!-- Query Input -->

                                <div class="search-term">

                                    <div class="search-input-wrapper">

                                        <i class="bi bi-search search-icon"></i>

                                        <input type="text" name="q" placeholder="What are you looking for?" 

                                               value="<?php echo htmlspecialchars($searchQuery); ?>" 

                                               class="form-control" aria-label="Search keywords">

                                    </div>

                                </div>

                                

                                <!-- Location Input -->

                                <div class="search-location">

                                    <div class="search-input-wrapper">

                                        <i class="bi bi-geo-alt search-icon"></i>

                                        <input type="text" name="location" placeholder="City, state or zip" 

                                               value="<?php echo htmlspecialchars($location); ?>" 

                                               class="form-control" aria-label="Location">

                                    </div>

                                </div>

                                

                                <!-- Radius Filter - Moved here from advanced filters -->

                                <div class="search-radius">

                                    <input type="range" id="radius-filter" name="radius" class="form-range" 

                                           min="5" max="100" step="5" value="<?php echo $radius; ?>">

                                    <span class="radius-value"><?php echo $radius; ?> miles</span>

                                </div>

                                

                                <button type="submit" class="btn btn-primary search-btn">

                                    <i class="bi bi-search me-2"></i>Search

                                </button>

                            </div>

                        </div>

                        

                        <!-- Advanced Filters Toggle - Text removed but keeping the toggle button -->

                        <div class="advanced-filters-toggle">

                            <button type="button" class="btn btn-text" data-bs-toggle="collapse" data-bs-target="#advancedFilters">

                                <i class="bi bi-sliders me-1"></i>Filters

                            </button>

                        </div>

                        

                        <!-- Advanced Filters Panel -->

                        <div class="collapse" id="advancedFilters">

                            <div class="advanced-filters-content">

                                <!-- Facility Types Section -->

                                <div class="facility-type-filters mb-3">

                                    <label class="form-label d-block mb-2">Facility Types (select multiple)</label>

                                    <div class="facility-type-options">

                                        <div class="row">

                                            <div class="col-md-4 col-sm-6 mb-2">

                                                <div class="form-check">

                                                    <input class="form-check-input" type="checkbox" name="facility_types[]" 

                                                           value="HH" id="typeHH" <?php echo in_array('HH', $facility_types) ? 'checked' : ''; ?>>

                                                    <label class="form-check-label" for="typeHH">

                                                        Sober Living Homes

                                                    </label>

                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-6 mb-2">

                                                <div class="form-check">

                                                    <input class="form-check-input" type="checkbox" name="facility_types[]" 

                                                           value="SA" id="typeSA" <?php echo in_array('SA', $facility_types) ? 'checked' : ''; ?>>

                                                    <label class="form-check-label" for="typeSA">

                                                        Treatment Centers

                                                    </label>

                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-6 mb-2">

                                                <div class="form-check">

                                                    <input class="form-check-input" type="checkbox" name="facility_types[]" 

                                                           value="DT" id="typeDT" <?php echo in_array('DT', $facility_types) ? 'checked' : ''; ?>>

                                                    <label class="form-check-label" for="typeDT">

                                                        Detox Facilities

                                                    </label>

                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-6 mb-2">

                                                <div class="form-check">

                                                    <input class="form-check-input" type="checkbox" name="facility_types[]" 

                                                           value="MH" id="typeMH" <?php echo in_array('MH', $facility_types) ? 'checked' : ''; ?>>

                                                    <label class="form-check-label" for="typeMH">

                                                        Mental Health

                                                    </label>

                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-6 mb-2">

                                                <div class="form-check">

                                                    <input class="form-check-input" type="checkbox" name="facility_types[]" 

                                                           value="SUMH" id="typeSUMH" <?php echo in_array('SUMH', $facility_types) ? 'checked' : ''; ?>>

                                                    <label class="form-check-label" for="typeSUMH">

                                                        Co-occurring Disorders

                                                    </label>

                                                </div>

                                            </div>

                                            <div class="col-md-4 col-sm-6 mb-2">

                                                <div class="form-check">

                                                    <input class="form-check-input" type="checkbox" name="facility_types[]" 

                                                           value="OP" id="typeOP" <?php echo in_array('OP', $facility_types) ? 'checked' : ''; ?>>

                                                    <label class="form-check-label" for="typeOP">

                                                        Outpatient Programs

                                                    </label>

                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                                

                                <!-- No additional filter controls as requested -->

                                <!-- Only keeping the facility types section -->



                            </div>

                        </div>

                    <!-- JavaScript for radius slider -->

<script>

document.addEventListener('DOMContentLoaded', function() {

    const radiusSlider = document.getElementById('radius-filter');

    const radiusValue = document.querySelector('.radius-value');

    

    if (radiusSlider && radiusValue) {

        radiusSlider.addEventListener('input', function() {

            radiusValue.textContent = this.value + ' miles';

        });

    }

});

</script>

                    </form>

                </div>

            </div>

        </div>

    </div>

</section>



<!-- Results Section -->

<section class="search-results">

    <div class="container">

        <div class="results-header">

            <div class="results-info">

                <h2><?php echo htmlspecialchars($dynamic_title); ?></h2>

                <p class="results-count"><?php echo number_format($total_count); ?> resources found</p>

            </div>

            

            <div class="view-toggle">

                <div class="btn-group" role="group" aria-label="View toggle">

                    <a href="<?php echo '/search?' . http_build_query(array_merge($search_params, ['view' => 'list'])); ?>" 

                       class="btn <?php echo $view !== 'map' ? 'btn-primary' : 'btn-outline-primary'; ?>" id="listViewBtn">

                        <i class="bi bi-list-ul me-1"></i>List

                    </a>

                    <a href="<?php echo '/search?' . http_build_query(array_merge($search_params, ['view' => 'map'])); ?>" 

                       class="btn <?php echo $view === 'map' ? 'btn-primary' : 'btn-outline-primary'; ?>" id="mapViewBtn">

                        <i class="bi bi-geo-alt me-1"></i>Map

                    </a>

                </div>

            </div>

        </div>

        

        <!-- List View -->

        <div id="listView" class="<?php echo $view === 'map' ? 'd-none' : ''; ?>">

            <?php if (count($facilities) > 0): ?>

                <div class="row row-equal-height">

                    <?php foreach ($facilities as $facility): ?>

                        <div class="col-lg-4 col-md-6 col-sm-12 mb-4">

                            <div class="card h-100 shadow-sm">

                                <div class="card-img-container p-2">

                                    <?php 

                                    $image_url = getFacilityImage($facility);

                                    ?>

                                    <img src="<?php echo $image_url; ?>" 

                                         class="card-img-top rounded" style="height: 180px; object-fit: cover; width: 100%;"

                                         alt="<?php echo htmlspecialchars($facility['name']); ?>" loading="lazy">

                                    

                                    <?php if (!empty($facility['is_verified'])): ?>

                                        <div class="position-absolute top-0 end-0 m-3 bg-white rounded-circle p-1" title="Verified Facility">

                                            <i class="bi bi-patch-check-fill text-primary"></i>

                                        </div>

                                    <?php endif; ?>

                                </div>

                                

                                <div class="card-body d-flex flex-column">

                                    <h3 class="card-title h5 mb-2">

                                        <a href="/facility/<?php echo getFacilitySlug($facility); ?>" class="text-decoration-none">

                                            <?php echo htmlspecialchars($facility['name']); ?>

                                        </a>

                                    </h3>

                                    

                                    <p class="card-text mb-2">

                                        <i class="bi bi-geo-alt text-secondary"></i>

                                        <?php echo htmlspecialchars($facility['city'] . ', ' . $facility['state_code']); ?>

                                        

                                        <?php if (!empty($facility['distance'])): ?>

                                            <span class="ms-1 text-muted">(<?php echo number_format($facility['distance'], 1); ?> mi)</span>

                                        <?php endif; ?>

                                    </p>

                                    

                                    <?php if (!empty($facility['avg_rating'])): ?>

                                        <div class="mb-2">

                                            <div class="stars d-inline-block">

                                                <?php for ($i = 1; $i <= 5; $i++): ?>

                                                    <?php if ($i <= floor($facility['avg_rating'])): ?>

                                                        <i class="bi bi-star-fill" style="color: gold;"></i>

                                                    <?php elseif ($i - 0.5 <= $facility['avg_rating']): ?>

                                                        <i class="bi bi-star-half" style="color: gold;"></i>

                                                    <?php else: ?>

                                                        <i class="bi bi-star" style="color: gold;"></i>

                                                    <?php endif; ?>

                                                <?php endfor; ?>

                                            </div>

                                            <span class="text-muted small">

                                                <?php echo number_format($facility['avg_rating'], 1); ?> 

                                                (<?php echo number_format($facility['total_reviews'] ?? 0); ?>)

                                            </span>

                                        </div>

                                    <?php endif; ?>

                                    

                                    <?php if (!empty($facility['facility_types'])): ?>

                                        <div class="mb-2">

                                            <?php $types = explode(',', $facility['facility_types']); ?>

                                            <?php foreach (array_slice($types, 0, 3) as $type): ?>

                                                <span class="badge text-dark me-1 mb-1" style="background-color: rgba(<?php 

                                                    switch(getBadgeClass($type)) {

                                                        case 'bg-primary': echo '13, 110, 253'; break;

                                                        case 'bg-success': echo '25, 135, 84'; break;

                                                        case 'bg-info': echo '13, 202, 240'; break;

                                                        case 'bg-warning': echo '255, 193, 7'; break;

                                                        case 'bg-secondary': echo '108, 117, 125'; break;

                                                        default: echo '108, 117, 125';

                                                    }

                                                ?>, 0.2);">

                                                    <?php echo htmlspecialchars(getFacilityTypeLabel($type)); ?>

                                                </span>

                                            <?php endforeach; ?>

                                            

                                            <?php if (count($types) > 3): ?>

                                                <span class="badge bg-light text-dark">+<?php echo count($types) - 3; ?> more</span>

                                            <?php endif; ?>

                                        </div>

                                    <?php endif; ?>

                                    

                             

                                    

                                    <div class="mt-auto">

                                        <a href="/facility/<?php echo getFacilitySlug($facility); ?>" class="btn btn-primary w-100 mb-2">

                                            View Details

                                        </a>

                                        

                                        <?php if (!empty($facility['phone'])): ?>

                                            <a href="tel:<?php echo preg_replace('/[^0-9]/', '', $facility['phone']); ?>" class="btn btn-success w-100 mb-2">

                                                <i class="bi bi-telephone-fill me-1"></i> Call Now

                                            </a>

                                        <?php endif; ?>

                                        

                                        <?php 

                                        $address = trim($facility['address_line1'] . ' ' . 

                                            ($facility['address_line2'] ?? '') . ' ' . 

                                            $facility['city'] . ', ' . 

                                            $facility['state_code'] . ' ' . 

                                            $facility['zip_code']);

                                        if (!empty($address)): 

                                        ?>

                                            <a href="https://maps.google.com/?q=<?php echo urlencode($address); ?>" 

                                               target="_blank" rel="noopener" class="btn btn-outline-secondary w-100">

                                                <i class="bi bi-map me-1"></i> Get Directions

                                            </a>

                                        <?php endif; ?>

                                    </div>

                                </div>

                            </div>

                        </div>

                    <?php endforeach; ?>

                </div>

                

                <!-- Pagination -->

                <?php if ($total_pages > 1): ?>

                    <div class="pagination-container text-center my-4">

                        <nav aria-label="Search results pagination">

                            <ul class="pagination justify-content-center">

                                <?php if ($page > 1): ?>

                                    <li class="page-item">

                                        <a class="page-link" href="/search?<?php echo http_build_query(array_merge($search_params, ['pg' => $page - 1])); ?>" aria-label="Previous">

                                            <span aria-hidden="true">&laquo;</span>

                                        </a>

                                    </li>

                                <?php else: ?>

                                    <li class="page-item disabled">

                                        <span class="page-link">

                                            <span aria-hidden="true">&laquo;</span>

                                        </span>

                                    </li>

                                <?php endif; ?>

                                

                                <?php

                                $start_page = max(1, $page - 2);

                                $end_page = min($total_pages, $page + 2);

                                

                                if ($start_page > 1) {

                                    echo '<li class="page-item"><a class="page-link" href="/search?' . 

                                         http_build_query(array_merge($search_params, ['page' => 1])) . 

                                         '">1</a></li>';

                                    

                                    if ($start_page > 2) {

                                        echo '<li class="page-item disabled"><span class="page-link border-0 bg-transparent">...</span></li>';

                                    }

                                }

                                

                                for ($i = $start_page; $i <= $end_page; $i++) {

                                    if ($i == $page) {

                                        echo '<li class="page-item active"><span class="page-link">' . $i . '</span></li>';

                                    } else {

                                        echo '<li class="page-item"><a class="page-link" href="/search?' . 

                                             http_build_query(array_merge($search_params, ['pg' => $i])) . 

                                             '">' . $i . '</a></li>';

                                    }

                                }

                                

                                if ($end_page < $total_pages) {

                                    if ($end_page < $total_pages - 1) {

                                        echo '<li class="page-item disabled"><span class="page-link border-0 bg-transparent">...</span></li>';

                                    }

                                    

                                    echo '<li class="page-item"><a class="page-link" href="/search?' . 

                                         http_build_query(array_merge($search_params, ['page' => $total_pages])) . 

                                         '">' . $total_pages . '</a></li>';

                                }

                                ?>

                                

                                <?php if ($page < $total_pages): ?>

                                    <li class="page-item">

                                        <a class="page-link" href="/search?<?php echo http_build_query(array_merge($search_params, ['pg' => $page + 1])); ?>" aria-label="Next">

                                            <span aria-hidden="true">&raquo;</span>

                                        </a>

                                    </li>

                                <?php else: ?>

                                    <li class="page-item disabled">

                                        <span class="page-link">

                                            <span aria-hidden="true">&raquo;</span>

                                        </span>

                                    </li>

                                <?php endif; ?>

                            </ul>

                        </nav>

                    </div>

                <?php endif; ?>

                

            <?php else: ?>

                <!-- No Results Found -->

                <div class="no-results">

                    <div class="no-results-icon">

                        <i class="bi bi-search"></i>

                    </div>

                    <h3>No Results Found</h3>

                    <p>We couldn't find any facilities matching your search criteria. Try adjusting your filters or searching with different terms.</p>

                    <div class="no-results-actions">

                        <a href="/search" class="btn btn-primary">Reset Search</a>

                        <a href="/contact" class="btn btn-outline-primary">Contact Us for Help</a>

                    </div>

                </div>

            <?php endif; ?>

        </div>

        

        <!-- Map View -->

        <div id="mapView" class="<?php echo $view !== 'map' ? 'd-none' : ''; ?>">

            <div class="map-container mb-4">

                <div id="facilitiesMap"></div>

            </div>

            

            <h3 class="mb-4">Resources on Map</h3>

            

            <div class="facilities-list">

                <?php if (count($map_facilities) > 0): ?>

                    <div class="row">

                        <?php foreach (array_slice($map_facilities, ($page - 1) * $items_per_page, $items_per_page) as $facility): ?>

                            <?php if (!empty($facility['latitude']) && !empty($facility['longitude'])): ?>

                                <div class="col-12 mb-3 map-facility-list-item" data-lat="<?php echo htmlspecialchars($facility['latitude']); ?>" data-lng="<?php echo htmlspecialchars($facility['longitude']); ?>">

                                    <div class="list-item-content p-3 border rounded d-flex flex-column flex-md-row align-items-start">

                                        <div class="facility-info flex-grow-1">

                                            <h4 class="h5 mb-1">

                                                <a href="/facility/<?php echo getFacilitySlug($facility); ?>" class="text-decoration-none">

                                                    <?php echo htmlspecialchars($facility['name']); ?>

                                                </a>

                                            </h4>

                                            

                                            <p class="mb-1">

                                                <i class="bi bi-geo-alt text-secondary"></i>

                                                <?php echo htmlspecialchars($facility['city'] . ', ' . $facility['state_code']); ?>

                                            </p>

                                            

                                            <?php if (!empty($facility['facility_types'])): ?>

                                                <div class="mb-2">

                                                    <?php $types = explode(',', $facility['facility_types']); ?>

                                                    <?php foreach (array_slice($types, 0, 3) as $type): ?>

                                                        <span class="badge text-dark me-1 mb-1" style="background-color: rgba(<?php 

                                                            switch(getBadgeClass($type)) {

                                                                case 'bg-primary': echo '13, 110, 253'; break;

                                                                case 'bg-success': echo '25, 135, 84'; break;

                                                                case 'bg-info': echo '13, 202, 240'; break;

                                                                case 'bg-warning': echo '255, 193, 7'; break;

                                                                case 'bg-secondary': echo '108, 117, 125'; break;

                                                                default: echo '108, 117, 125';

                                                            }

                                                        ?>, 0.2);">

                                                            <?php echo htmlspecialchars(getFacilityTypeLabel($type)); ?>

                                                        </span>

                                                    <?php endforeach; ?>

                                                </div>

                                            <?php endif; ?>

                                        </div>

                                        <div class="facility-actions mt-2 mt-md-0 ms-md-3">

                                            <a href="/facility/<?php echo getFacilitySlug($facility); ?>" class="btn btn-primary btn-sm d-block mb-1">

                                                View Details

                                            </a>

                                        </div>

                                    </div>

                                </div>

                            <?php endif; ?>

                        <?php endforeach; ?>

                    </div>

                    

                    <!-- Pagination for Map View -->

                    <?php if (ceil(count($map_facilities) / $items_per_page) > 1): ?>

                        <div class="pagination-container text-center my-4">

                            <nav aria-label="Map results pagination">

                                <ul class="pagination justify-content-center">

                                    <?php if ($page > 1): ?>

                                        <li class="page-item">

                                            <a class="page-link" href="/search?<?php echo http_build_query(array_merge($search_params, ['pg' => $page - 1])); ?>" aria-label="Previous">

                                                <span aria-hidden="true">&laquo;</span>

                                            </a>

                                        </li>

                                    <?php else: ?>

                                        <li class="page-item disabled">

                                            <span class="page-link">

                                                <span aria-hidden="true">&laquo;</span>

                                            </span>

                                        </li>

                                    <?php endif; ?>

                                    

                                    <?php

                                    $total_map_pages = ceil(count($map_facilities) / $items_per_page);

                                    $start_page = max(1, $page - 2);

                                    $end_page = min($total_map_pages, $page + 2);

                                    

                                    if ($start_page > 1) {

                                        echo '<li class="page-item"><a class="page-link" href="/search?' . 

                                             http_build_query(array_merge($search_params, ['pg' => 1])) . 

                                             '">1</a></li>';

                                        

                                        if ($start_page > 2) {

                                            echo '<li class="page-item disabled"><span class="page-link">...</span></li>';

                                        }

                                    }

                                    

                                    for ($i = $start_page; $i <= $end_page; $i++) {

                                        if ($i == $page) {

                                            echo '<li class="page-item active"><span class="page-link">' . $i . '</span></li>';

                                        } else {

                                            echo '<li class="page-item"><a class="page-link" href="/search?' . 

                                                 http_build_query(array_merge($search_params, ['pg' => $i])) . 

                                                 '">' . $i . '</a></li>';

                                        }

                                    }

                                    

                                    if ($end_page < $total_map_pages) {

                                        if ($end_page < $total_map_pages - 1) {

                                            echo '<li class="page-item disabled"><span class="page-link">...</span></li>';

                                        }

                                        

                                        echo '<li class="page-item"><a class="page-link" href="/search?' . 

                                             http_build_query(array_merge($search_params, ['pg' => $total_map_pages])) . 

                                             '">' . $total_map_pages . '</a></li>';

                                    }

                                    ?>

                                    

                                    <?php if ($page < $total_map_pages): ?>

                                        <li class="page-item">

                                            <a class="page-link" href="/search?<?php echo http_build_query(array_merge($search_params, ['pg' => $page + 1])); ?>" aria-label="Next">

                                                <span aria-hidden="true">&raquo;</span>

                                            </a>

                                        </li>

                                    <?php else: ?>

                                        <li class="page-item disabled">

                                            <span class="page-link">

                                                <span aria-hidden="true">&raquo;</span>

                                            </span>

                                        </li>

                                    <?php endif; ?>

                                </ul>

                            </nav>

                        </div>

                    <?php endif; ?>

                    

                <?php else: ?>

                    <div class="alert alert-info">

                        <p class="mb-0">No facilities found with location data.</p>

                    </div>

                <?php endif; ?>

            </div>

        </div>

    </div>

</section>





<!-- Include JavaScript for equal height cards -->

<script>

// Equal height cards function

document.addEventListener('DOMContentLoaded', function() {

    // Function to equalize card heights within each row

    function equalizeCardHeights() {

        // Reset all card heights first

        document.querySelectorAll('.card').forEach(card => {

            card.style.height = '';

            card.querySelector('.card-body').style.height = '';

            if (card.querySelector('.card-text')) {

                card.querySelector('.card-text').style.height = '';

                card.querySelector('.card-text').style.overflow = '';

            }

        });

        

        // Get all rows

        const rows = document.querySelectorAll('.row');

        

        rows.forEach(row => {

            // Only process facility card rows

            if (!row.querySelector('.card')) return;

            

            const cards = row.querySelectorAll('.card');

            if (cards.length === 0) return;

            

            // Group cards by their offsetTop (vertical position) to identify rows

            const cardRows = {};

            cards.forEach(card => {

                const top = card.offsetTop;

                if (!cardRows[top]) cardRows[top] = [];

                cardRows[top].push(card);

            });

            

            // For each row of cards, find the tallest card and set all to that height

            Object.keys(cardRows).forEach(top => {

                const rowCards = cardRows[top];

                

                // Find max heights for various elements

                let maxCardHeight = 0;

                let maxBodyHeight = 0;

                let maxTextHeight = 0;

                

                rowCards.forEach(card => {

                    maxCardHeight = Math.max(maxCardHeight, card.offsetHeight);

                    

                    const cardBody = card.querySelector('.card-body');

                    if (cardBody) {

                        maxBodyHeight = Math.max(maxBodyHeight, cardBody.offsetHeight);

                    }

                    

                    const cardText = card.querySelector('.card-text');

                    if (cardText) {

                        maxTextHeight = Math.max(maxTextHeight, cardText.scrollHeight);

                    }

                });

                

                // Set equal heights with padding consideration

                rowCards.forEach(card => {

                    card.style.height = maxCardHeight + 'px';

                    

                    const cardBody = card.querySelector('.card-body');

                    if (cardBody) {

                        cardBody.style.height = maxBodyHeight + 'px';

                    }

                    

                    const cardText = card.querySelector('.card-text');

                    if (cardText) {

                        cardText.style.height = maxTextHeight + 'px';

                        cardText.style.overflow = 'hidden';

                    }

                });

            });

        });

    }

    

    // Run on page load

    equalizeCardHeights();

    

    // Run on window resize (debounced)

    let resizeTimer;

    window.addEventListener('resize', function() {

        clearTimeout(resizeTimer);

        resizeTimer = setTimeout(equalizeCardHeights, 250);

    });

});

</script>

<script>

// Equal height cards function

document.addEventListener('DOMContentLoaded', function() {

    // Function to equalize card heights within each row

    function equalizeCardHeights() {

        // Reset all card heights first

        document.querySelectorAll('.card').forEach(card => {

            card.style.height = '';

            card.querySelector('.card-body').style.height = '';

            if (card.querySelector('.card-text')) {

                card.querySelector('.card-text').style.height = '';

                card.querySelector('.card-text').style.overflow = '';

            }

        });

        

        // Get all rows

        const rows = document.querySelectorAll('.row');

        

        rows.forEach(row => {

            // Only process facility card rows

            if (!row.querySelector('.card')) return;

            

            const cards = row.querySelectorAll('.card');

            if (cards.length === 0) return;

            

            // Group cards by their offsetTop (vertical position) to identify rows

            const cardRows = {};

            cards.forEach(card => {

                const top = card.offsetTop;

                if (!cardRows[top]) cardRows[top] = [];

                cardRows[top].push(card);

            });

            

            // For each row of cards, find the tallest card and set all to that height

            Object.keys(cardRows).forEach(top => {

                const rowCards = cardRows[top];

                

                // Find max heights for various elements

                let maxCardHeight = 0;

                let maxBodyHeight = 0;

                let maxTextHeight = 0;

                

                rowCards.forEach(card => {

                    maxCardHeight = Math.max(maxCardHeight, card.offsetHeight);

                    

                    const cardBody = card.querySelector('.card-body');

                    if (cardBody) {

                        maxBodyHeight = Math.max(maxBodyHeight, cardBody.offsetHeight);

                    }

                    

                    const cardText = card.querySelector('.card-text');

                    if (cardText) {

                        maxTextHeight = Math.max(maxTextHeight, cardText.scrollHeight);

                    }

                });

                

                // Set equal heights with padding consideration

                rowCards.forEach(card => {

                    card.style.height = maxCardHeight + 'px';

                    

                    const cardBody = card.querySelector('.card-body');

                    if (cardBody) {

                        cardBody.style.height = maxBodyHeight + 'px';

                    }

                    

                    const cardText = card.querySelector('.card-text');

                    if (cardText) {

                        cardText.style.height = maxTextHeight + 'px';

                        cardText.style.overflow = 'hidden';

                    }

                });

            });

        });

    }

    

    // Run on page load

    equalizeCardHeights();

    

    // Run on window resize (debounced)

    let resizeTimer;

    window.addEventListener('resize', function() {

        clearTimeout(resizeTimer);

        resizeTimer = setTimeout(equalizeCardHeights, 250);

    });

});

</script>



<!-- Modified Map Initialization Script for Map View -->

<?php if ($view === 'map'): ?>

<script>

document.addEventListener('DOMContentLoaded', function() {

    // Initialize map function

    function initMap() {

        const mapContainer = document.getElementById('facilitiesMap');

        if (!mapContainer) return;

        

        // Create map with default center (US)

        const map = new google.maps.Map(mapContainer, {

            center: { lat: 39.8283, lng: -98.5795 },

            zoom: 4,

            mapTypeControl: true,

            fullscreenControl: true,

            streetViewControl: false,

            zoomControl: true,

            styles: [

                {

                    "featureType": "administrative",

                    "elementType": "geometry",

                    "stylers": [{"visibility": "simplified"}]

                },

                {

                    "featureType": "landscape",

                    "stylers": [{"color": "#f8f9fa"}]

                },

                {

                    "featureType": "poi",

                    "stylers": [{"visibility": "simplified"}]

                },

                {

                    "featureType": "road",

                    "stylers": [{"visibility": "simplified"}]

                },

                {

                    "featureType": "water",

                    "stylers": [{"color": "#d1e5f9"}]

                }

            ]

        });

        

        // Store map reference

        window.facilitiesMap = map;

        

        // Setup for markers

        const markers = [];

        const bounds = new google.maps.LatLngBounds();

        const infoWindow = new google.maps.InfoWindow();

        let hasMarkers = false;

        

        // Process facility items for map

        const facilityItems = document.querySelectorAll('[data-lat][data-lng]');

        facilityItems.forEach(item => {

            const lat = parseFloat(item.dataset.lat);

            const lng = parseFloat(item.dataset.lng);

            

            if (!isNaN(lat) && !isNaN(lng)) {

                hasMarkers = true;

                const position = { lat, lng };

                

                // Create marker with animation

                const marker = new google.maps.Marker({

                    position: position,

                    map: map,

                    title: item.querySelector('h4')?.textContent || 'Facility',

                    animation: google.maps.Animation.DROP

                });

                

                // Create info window content from facility item

                marker.addListener('click', () => {

                    const name = item.querySelector('h4')?.textContent;

                    const address = item.querySelector('p')?.textContent;

                    const link = item.querySelector('a')?.href;

                    

                    const content = `

                        <div class="map-info-window">

                            <div class="info-window-content">

                                <h4 style="font-size: 16px; margin-bottom: 8px; color: #333;">${name || 'Facility'}</h4>

                                <p style="font-size: 14px; margin-bottom: 10px; color: #555;">${address || ''}</p>

                                ${link ? `<a href="${link}" class="btn btn-sm btn-primary" style="display: inline-block; padding: 5px 10px; background-color: #4361ee; color: white; text-decoration: none; border-radius: 4px; text-align: center;">View Details</a>` : ''}

                            </div>

                        </div>

                    `;

                    

                    infoWindow.setContent(content);

                    infoWindow.open(map, marker);

                    

                    // Highlight corresponding item

                    document.querySelectorAll('.map-facility-card').forEach(el => el.classList.remove('highlighted-facility'));

                    item.querySelector('.map-facility-card')?.classList.add('highlighted-facility');

                    

                    // Scroll item into view if needed

                    item.scrollIntoView({ behavior: 'smooth', block: 'nearest' });

                });

                

                markers.push(marker);

                bounds.extend(position);

                

                // Make card items interactive

                item.addEventListener('click', function(e) {

                    if (e.target.closest('a')) return; // Allow links to work normally

                    

                    // Highlight this item

                    document.querySelectorAll('.map-facility-card').forEach(el => el.classList.remove('highlighted-facility'));

                    this.querySelector('.map-facility-card').classList.add('highlighted-facility');

                    

                    // Center map on this facility

                    map.setCenter(position);

                    map.setZoom(14);

                    

                    // Open info window

                    const name = item.querySelector('h4')?.textContent;

                    const address = item.querySelector('p')?.textContent;

                    const link = item.querySelector('a')?.href;

                    

                    const content = `

                        <div class="map-info-window">

                            <div class="info-window-content">

                                <h4 style="font-size: 16px; margin-bottom: 8px; color: #333;">${name || 'Facility'}</h4>

                                <p style="font-size: 14px; margin-bottom: 10px; color: #555;">${address || ''}</p>

                                ${link ? `<a href="${link}" class="btn btn-sm btn-primary" style="display: inline-block; padding: 5px 10px; background-color: #4361ee; color: white; text-decoration: none; border-radius: 4px; text-align: center;">View Details</a>` : ''}

                            </div>

                        </div>

                    `;

                    

                    infoWindow.setContent(content);

                    infoWindow.open(map, marker);

                });

            }

        });

        

        // Adjust map boundaries based on markers

        if (hasMarkers) {

            map.fitBounds(bounds);

            

            // Prevent excessive zoom when few markers

            google.maps.event.addListenerOnce(map, 'bounds_changed', function() {

                if (map.getZoom() > 15) map.setZoom(15);

            });

        }

    }

    

    // Initialize map

    if (typeof google !== 'undefined' && google.maps) {

        initMap();

    } else {

        // If Google Maps API not loaded yet, will be called by callback

        window.initMap = initMap;

    }

});

</script>







<!-- Load Google Maps API -->

<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo htmlspecialchars($google_maps_api_key); ?>&callback=initMap"></script>

<?php endif; ?>



<?php

// Include footer

include(BASE_PATH . '/app/Views/components/footer.php');

?>