<?php

/**

 * States Directory Template - SoberList.org

 * This template handles both the states list and individual state views

 */



// Include states logic (which loads state data)

require_once(BASE_PATH . '/app/Views/pages/states/states.php');



// Include config (which handles meta tags and schema)

require_once(BASE_PATH . '/app/Views/pages/states/config.php');



// Make sure the FAQ generator is included

require_once(BASE_PATH . '/includes/faq-accordion.php');



// Helper function for facility type badge classes with pastel colors

function getBadgeClass($type) {

    $type = trim($type);

    $classes = [

        'HH' => 'badge-pastel-blue',

        'SA' => 'badge-pastel-green',

        'DT' => 'badge-pastel-purple',

        'MH' => 'badge-pastel-orange',

        'SUMH' => 'badge-pastel-pink',

        'OP' => 'badge-pastel-teal',

    ];

    

    return isset($classes[$type]) ? $classes[$type] : 'badge-pastel-gray';

}



// Helper function for facility type labels

function getFacilityTypeLabel($type) {

    $type = trim($type);

    $labels = [

        'HH' => 'Sober Living',

        'SA' => 'Treatment',

        'DT' => 'Detox',

        'MH' => 'Mental Health',

        'SUMH' => 'Co-occurring',

        'OP' => 'Outpatient',

    ];

    

    return isset($labels[$type]) ? $labels[$type] : $type;

}



// Include standard header

include(BASE_PATH . '/app/Views/components/header.php');

?>



<!-- Breadcrumb section -->

<div class="breadcrumbs bg-light py-2">

    <div class="container">

        <div class="visually-hidden">Location Navigation</div>

        <?php include_once BASE_PATH . '/app/Views/components/breadcrumbs.php'; ?>

    </div>

</div>



<section class="states-directory py-5 mb-5">

    <div class="container">

        <?php if (!isset($state_code)): ?>

            <!-- LIST OF ALL STATES VIEW -->

            <div class="row mb-5">

                <div class="col-lg-10 col-md-12 mx-auto">

                    <h1 class="display-5 mb-4 text-center">Recovery Resources by State</h1>

                    <p class="lead text-center mb-5">Browse our comprehensive directory of recovery facilities organized by state to find the support you need.</p>

                    

                    <!-- States listing card -->

                    <div class="card shadow-sm mb-5">

                        <div class="card-header bg-light">

                            <h2 class="h4 mb-0">Select a State</h2>

                        </div>

                        <div class="card-body">

                            <?php foreach ($states_by_region as $region => $region_states): ?>

                                <div class="region-section mb-4">

                                    <h3 class="h5 mb-3 border-bottom pb-2"><?php echo htmlspecialchars($region); ?></h3>

                                    <div class="state-list">

                                        <?php foreach ($region_states as $state): ?>

                                            <div class="state-item py-2">

                                                <a href="/states/<?php echo strtolower($state['state_code']); ?>" class="text-decoration-none">

                                                    <i class="bi bi-geo-alt me-2 text-primary"></i>

                                                    <?php echo htmlspecialchars($state['state_name']); ?>

                                                </a>

                                            </div>

                                        <?php endforeach; ?>

                                    </div>

                                </div>

                            <?php endforeach; ?>

                        </div>

                    </div>

                </div>

            </div>

            

        <?php else: ?>

            <!-- INDIVIDUAL STATE FACILITIES VIEW -->

            <div class="row mb-4">

                <div class="col-lg-10 col-md-12 mx-auto">

                    <h1 class="display-5 mb-3"><?php echo htmlspecialchars($state_info['state_name']); ?> Recovery Resources</h1>

                    <p class="lead mb-4">Browse recovery resources in <?php echo htmlspecialchars($state_info['state_name']); ?> to find the support you need on your recovery journey.</p>



                    <!-- State Agencies Section -->

                    <?php

                    // Query to get state agencies for this state

                    $agencies_stmt = $db->prepare("

                        SELECT * FROM state_agencies

                        WHERE state_id = ?

                        ORDER BY name ASC

                    ");

                    $agencies_stmt->execute([$state_info['id']]);

                    $state_agencies = $agencies_stmt->fetchAll(PDO::FETCH_ASSOC);

                    

                    if (!empty($state_agencies)):

                    ?>

                    <div class="state-agencies mb-4">

                        <h2 class="h4 mb-3">Official <?php echo htmlspecialchars($state_info['state_name']); ?> Recovery Resources</h2>

                        <div class="row">

                            <?php foreach ($state_agencies as $agency): ?>

                                <div class="col-lg-6 mb-4">

                                    <div class="card h-100 shadow-sm">

                                        <div class="card-body">

                                            <h3 class="h5 card-title"><?php echo htmlspecialchars($agency['name']); ?></h3>

                                            

                                            <div class="mb-3">

                                                <p class="mb-1">

                                                    <i class="bi bi-geo-alt-fill text-secondary me-2"></i>

                                                    <?php echo htmlspecialchars($agency['address_line1']); ?>

                                                    <?php if (!empty($agency['address_line2'])): ?>

                                                        <br><span class="ms-4"><?php echo htmlspecialchars($agency['address_line2']); ?></span>

                                                    <?php endif; ?>

                                                    <br><span class="ms-4"><?php echo htmlspecialchars($agency['city']); ?>, <?php echo htmlspecialchars($agency['state_code']); ?> <?php echo htmlspecialchars($agency['zip_code']); ?></span>

                                                </p>

                                            </div>

                                            

                                            <?php if (!empty($agency['phone'])): ?>

                                                <p class="mb-2">

                                                    <i class="bi bi-telephone-fill text-secondary me-2"></i>

                                                    <a href="tel:<?php echo preg_replace('/[^0-9]/', '', $agency['phone']); ?>" class="text-decoration-none">

                                                        <?php echo htmlspecialchars($agency['phone']); ?>

                                                    </a>

                                                </p>

                                            <?php endif; ?>

                                            

                                            <?php if (!empty($agency['email'])): ?>

                                                <p class="mb-2">

                                                    <i class="bi bi-envelope-fill text-secondary me-2"></i>

                                                    <a href="mailto:<?php echo htmlspecialchars($agency['email']); ?>" class="text-decoration-none">

                                                        <?php echo htmlspecialchars($agency['email']); ?>

                                                    </a>

                                                </p>

                                            <?php endif; ?>

                                            

                                            <?php if (!empty($agency['website'])): ?>

                                                <p class="mb-0">

                                                    <i class="bi bi-globe text-secondary me-2"></i>

                                                    <a href="<?php echo htmlspecialchars($agency['website']); ?>" class="text-decoration-none" target="_blank" rel="noopener">

                                                        Visit Website

                                                        <i class="bi bi-box-arrow-up-right ms-1 small"></i>

                                                    </a>

                                                </p>

                                            <?php endif; ?>

                                        </div>

                                    </div>

                                </div>

                            <?php endforeach; ?>

                        </div>

                    </div>

                    <?php endif; ?>



                    <!-- Facilities listing -->

                    <div class="card shadow-sm">

                        <div class="card-header bg-light">

                            <h2 class="h5 mb-0">Facilities in <?php echo htmlspecialchars($state_info['state_name']); ?></h2>

                        </div>

                        <div class="card-body p-0">

                            <?php if (!empty($facilities)): ?>

                                <div class="facility-list bg-light p-3">

                                    <?php foreach ($facilities as $facility): ?>

                                        <div class="facility-item bg-white p-4 mb-3 rounded shadow-sm">

                                            <div class="row">

                                                <div class="col-md-8">

                                                    <h3 class="h5 mb-2"><?php echo htmlspecialchars($facility['name']); ?></h3>

                                                    

                                                    <!-- Updated Facility Type Labels with Pastel Colors -->

                                                    <div class="facility-types mb-2">

                                                        <?php 

                                                        // Check if facility types exist in the data

                                                        if (!empty($facility['facility_types']) && is_array($facility['facility_types'])): 

                                                            foreach ($facility['facility_types'] as $type): 

                                                        ?>

                                                            <span class="badge <?php echo getBadgeClass($type); ?> me-1 mb-1">

                                                                <?php echo htmlspecialchars(getFacilityTypeLabel($type)); ?>

                                                            </span>

                                                        <?php 

                                                            endforeach;

                                                        // If types are a comma-separated string

                                                        elseif (!empty($facility['facility_types']) && is_string($facility['facility_types'])):

                                                            $types_array = explode(',', $facility['facility_types']);

                                                            foreach ($types_array as $type):

                                                                $type = trim($type);

                                                                if (!empty($type)):

                                                        ?>

                                                            <span class="badge <?php echo getBadgeClass($type); ?> me-1 mb-1">

                                                                <?php echo htmlspecialchars(getFacilityTypeLabel($type)); ?>

                                                            </span>

                                                        <?php 

                                                                endif;

                                                            endforeach;

                                                        // If there's a single 'facility_type' field instead

                                                        elseif (!empty($facility['facility_type'])):

                                                        ?>

                                                            <span class="badge <?php echo getBadgeClass($facility['facility_type']); ?> me-1 mb-1">

                                                                <?php echo htmlspecialchars(getFacilityTypeLabel($facility['facility_type'])); ?>

                                                            </span>

                                                        <?php 

                                                        // Fallback for service types and other variations

                                                        elseif (!empty($facility['service_types']) && is_array($facility['service_types'])):

                                                            foreach ($facility['service_types'] as $type): 

                                                        ?>

                                                            <span class="badge <?php echo getBadgeClass($type); ?> me-1 mb-1">

                                                                <?php echo htmlspecialchars(getFacilityTypeLabel($type)); ?>

                                                            </span>

                                                        <?php 

                                                            endforeach;

                                                        elseif (!empty($facility['services'])):

                                                            $services = is_array($facility['services']) ? $facility['services'] : explode(',', $facility['services']);

                                                            foreach ($services as $service):

                                                                $service = trim($service);

                                                                if (!empty($service)):

                                                        ?>

                                                            <span class="badge <?php echo getBadgeClass($service); ?> me-1 mb-1">

                                                                <?php echo htmlspecialchars(getFacilityTypeLabel($service)); ?>

                                                            </span>

                                                        <?php 

                                                                endif;

                                                            endforeach;

                                                        // Last resort fallback if no type data is found

                                                        else:

                                                        ?>

                                                            <span class="badge badge-pastel-gray me-1 mb-1">Recovery Resource</span>

                                                        <?php endif; ?>

                                                    </div>

                                                    

                                                    <p class="mb-0">

                                                        <i class="bi bi-geo-alt me-2 text-secondary"></i>

                                                        <?php echo htmlspecialchars($facility['city']); ?>, <?php echo htmlspecialchars($state_info['state_code']); ?>

                                                    </p>

                                                </div>

                                                <div class="col-md-4 text-md-end mt-3 mt-md-0">

                                                    <a href="/facility/<?php echo get_facility_slug($facility); ?>" class="btn btn-primary">

                                                        View Details

                                                    </a>

                                                </div>

                                            </div>

                                        </div>

                                    <?php endforeach; ?>

                                </div>

                                

                                <!-- Simple Numbered Pagination -->

                                <?php if ($total_pages > 1): ?>

                                    <div class="pagination-container">

                                        <nav aria-label="Facility page navigation">

                                            <ul class="pagination" style="display: flex; flex-direction: row; flex-wrap: wrap; justify-content: center; list-style: none; padding: 0; margin: 0;">

                                                <?php if ($current_page > 1): ?>

                                                    <li style="margin: 0 3px; display: inline-block;">

                                                        <a style="display: flex; align-items: center; justify-content: center; min-width: 38px; min-height: 38px; padding: 0.5rem 0.75rem; color: #0056b3; background-color: #fff; border: 1px solid #dee2e6; border-radius: 0.25rem; text-decoration: none;" href="<?php echo update_query_string(['page' => $current_page - 1]); ?>" aria-label="Previous">

                                                            <i class="bi bi-chevron-left"></i>

                                                        </a>

                                                    </li>

                                                <?php else: ?>

                                                    <li style="margin: 0 3px; display: inline-block;">

                                                        <span style="display: flex; align-items: center; justify-content: center; min-width: 38px; min-height: 38px; padding: 0.5rem 0.75rem; color: #6c757d; background-color: #fff; border: 1px solid #dee2e6; border-radius: 0.25rem; opacity: 0.65; pointer-events: none;">

                                                            <i class="bi bi-chevron-left"></i>

                                                        </span>

                                                    </li>

                                                <?php endif; ?>

                                                

                                                <?php

                                                // Simple sequential page numbers - show up to 10 pages

                                                $max_buttons = 10;

                                                $total_buttons = min($total_pages, $max_buttons);

                                                

                                                // Calculate which sequence of pages to show

                                                if ($total_pages <= $max_buttons) {

                                                    // If we have fewer pages than max buttons, show all pages

                                                    $start_page = 1;

                                                    $end_page = $total_pages;

                                                } else {

                                                    // Calculate centered window of pages

                                                    $start_page = max(1, min($current_page - floor($max_buttons/2), $total_pages - $max_buttons + 1));

                                                    $end_page = min($start_page + $max_buttons - 1, $total_pages);

                                                }

                                                

                                                // Generate page links

                                                for ($i = $start_page; $i <= $end_page; $i++) {

                                                    if ($i == $current_page) {

                                                        // Active page

                                                        echo '<li style="margin: 0 3px; display: inline-block;">';

                                                        echo '<span style="display: flex; align-items: center; justify-content: center; min-width: 38px; min-height: 38px; padding: 0.5rem 0.75rem; color: white; background-color: #0056b3; border: 1px solid #0056b3; border-radius: 0.25rem;">' . $i . '</span>';

                                                        echo '</li>';

                                                    } else {

                                                        // Non-active page

                                                        echo '<li style="margin: 0 3px; display: inline-block;">';

                                                        echo '<a style="display: flex; align-items: center; justify-content: center; min-width: 38px; min-height: 38px; padding: 0.5rem 0.75rem; color: #0056b3; background-color: #fff; border: 1px solid #dee2e6; border-radius: 0.25rem; text-decoration: none; transition: background-color 0.15s ease-in-out;" href="' . update_query_string(['page' => $i]) . '">' . $i . '</a>';

                                                        echo '</li>';

                                                    }

                                                }

                                                ?>

                                                

                                                <?php if ($current_page < $total_pages): ?>

                                                    <li style="margin: 0 3px; display: inline-block;">

                                                        <a style="display: flex; align-items: center; justify-content: center; min-width: 38px; min-height: 38px; padding: 0.5rem 0.75rem; color: #0056b3; background-color: #fff; border: 1px solid #dee2e6; border-radius: 0.25rem; text-decoration: none;" href="<?php echo update_query_string(['page' => $current_page + 1]); ?>" aria-label="Next">

                                                            <i class="bi bi-chevron-right"></i>

                                                        </a>

                                                    </li>

                                                <?php else: ?>

                                                    <li style="margin: 0 3px; display: inline-block;">

                                                        <span style="display: flex; align-items: center; justify-content: center; min-width: 38px; min-height: 38px; padding: 0.5rem 0.75rem; color: #6c757d; background-color: #fff; border: 1px solid #dee2e6; border-radius: 0.25rem; opacity: 0.65; pointer-events: none;">

                                                            <i class="bi bi-chevron-right"></i>

                                                        </span>

                                                    </li>

                                                <?php endif; ?>

                                            </ul>

                                        </nav>

                                    </div>

                                <?php endif; ?>

                                

                            <?php else: ?>

                                <div class="p-4 text-center">

                                    <div class="alert alert-info">

                                        <i class="bi bi-info-circle me-2"></i>

                                        No facilities found in this state.

                                    </div>

                                </div>

                            <?php endif; ?>

                        </div>

                    </div>

                </div>

            </div>

        <?php endif; ?>

    </div>

</section>



<!-- Extra space before footer -->

<div style="height: 50px; clear: both;"></div>



<?php 

// Include footer

include(BASE_PATH . '/app/Views/components/footer.php'); 

?>