<?php
// ARTICLE VIEWER - Simple page that displays articles
require_once 'includes/config.php';
require_once 'functions_live.php';
require_once 'functions.php'; // For timeAgo function

// Get the slug from URL parameter
$slug = isset($_GET['slug']) ? $_GET['slug'] : '';

if (empty($slug)) {
    // No slug - redirect to homepage
    header("Location: /");
    exit;
}

// Try to get article from database
$article = getArticleBySlugFromDB($slug);

if (!$article) {
    // Article not found - show 404
    header("HTTP/1.0 404 Not Found");
    $pageType = 'static';
    $pageData = [
        'title' => 'Article Not Found',
        'description' => 'The requested article was not found.'
    ];
    
    include 'includes/head.php';
    include 'includes/nav.php';
    echo '<main id="main-content"><div class="container"><div class="static-content">';
    echo '<h1>Article Not Found</h1>';
    echo '<p>Sorry, we couldn\'t find the article you\'re looking for.</p>';
    echo '<p><a href="/">← Back to Homepage</a></p>';
    echo '</div></div></main>';
    include 'includes/footer.php';
    exit;
}

// Article found - set up page data
$pageType = 'article';
$relatedArticles = getRelatedArticlesFromDB();

// Render the article page
include 'includes/head.php';
include 'includes/nav.php';
?>
<main id="main-content">
    <?php include 'templates/article.php'; ?>
</main>
<?php include 'includes/footer.php'; ?>