<div class="container">
    
    <?php if ($featuredArticle): ?>
    <!-- Featured Article -->
    <article class="featured-article">
        <div class="featured-image">
            <picture>
                <source srcset="<?= getOptimizedImageUrl('', 'page', $featuredArticle) ?>" type="image/webp">
                <img src="<?= getOptimizedImageUrl('', 'og', $featuredArticle) ?>" 
                     alt="<?= htmlspecialchars($featuredArticle['establishment_name'] ?? 'Featured article') ?> inspection report" 
                     width="800" 
                     height="400"
                     loading="eager"
                     onload="this.classList.add('loaded')">
            </picture>
        </div>
        <div class="featured-content">
            <span class="featured-badge">Breaking</span>
            <h2 class="article-title"><?= htmlspecialchars($featuredArticle['title']) ?></h2>
            <p class="article-meta"><?= htmlspecialchars($featuredArticle['city']) ?>, <?= htmlspecialchars($featuredArticle['state']) ?> • <?= htmlspecialchars($featuredArticle['formatted_time']) ?></p>
            <p class="article-excerpt"><?= htmlspecialchars($featuredArticle['excerpt']) ?></p>
            <a href="/<?= htmlspecialchars($featuredArticle['slug']) ?>" class="article-link">Read full story →</a>
        </div>
    </article>
    <?php endif; ?>

    <?php if (!empty($homepageSections)): ?>
    <!-- Dynamic Homepage Sections -->
    <?php foreach ($homepageSections as $sectionKey => $section): ?>
    <?php if (!empty($section['articles'])): ?>
    <section class="news-section">
        <h2 class="section-title"><?= htmlspecialchars($section['title']) ?></h2>
        <div class="articles-grid">
            <?php foreach ($section['articles'] as $article): ?>
            <article class="article-card">
                <a href="/<?= htmlspecialchars($article['slug']) ?>" class="article-link">
                    <div class="article-image">
                        <picture>
                            <source srcset="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" type="image/webp">
                            <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                                 alt="<?= htmlspecialchars($article['establishment_name'] ?? 'Restaurant inspection') ?>"
                                 loading="lazy"
                                 width="400"
                                 height="300"
                                 onload="this.classList.add('loaded')">
                        </picture>
                    </div>
                    <div class="article-content">
                        <h3 class="article-title"><?= htmlspecialchars($article['title']) ?></h3>
                        <?php if (!empty($article['excerpt'])): ?>
                        <p class="article-excerpt"><?= htmlspecialchars(substr($article['excerpt'], 0, 150)) ?>...</p>
                        <?php endif; ?>
                        <div class="article-meta">
                            <span class="location"><?= htmlspecialchars($article['city']) ?>, <?= htmlspecialchars($article['state']) ?></span>
                            <span class="time"><?= htmlspecialchars($article['formatted_time']) ?></span>
                        </div>
                    </div>
                </a>
            </article>
            <?php endforeach; ?>
        </div>
    </section>
    <?php endif; ?>
    <?php endforeach; ?>
    <?php endif; ?>

    <!-- View All News Link -->
    <div class="view-all-news">
        <a href="/news" class="btn btn-primary">View All News →</a>
    </div>
    
    <!-- Important Notice -->
    <div class="disclaimer-notice">
        <strong>Important:</strong> This site reports on historical health inspection data from official government sources. 
        Articles are automatically generated based on government data. If you find a factual error, please 
        <a href="/contact">notify us</a> and we will work to correct it.
        <a href="/disclaimer">Read Full Disclaimer</a>
    </div>
</div>

<style>
/* Disclaimer Notice */
.disclaimer-notice {
    background: #fff3cd;
    border: 1px solid #ffc107;
    border-radius: 4px;
    padding: 1rem;
    margin-top: 3rem;
    margin-bottom: 2rem;
    font-size: 0.875rem;
    line-height: 1.5;
    color: #856404;
}

.disclaimer-notice a {
    color: #856404;
    text-decoration: underline;
    font-weight: 500;
}

/* Dark mode disclaimer */
:root:not(.light-mode) .disclaimer-notice {
    background: #332701;
    border-color: #664d03;
    color: #ffca2c;
}

:root:not(.light-mode) .disclaimer-notice a {
    color: #ffca2c;
}

/* News Sections */
.news-section {
    margin-bottom: 3rem;
}

.section-title {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 1.5rem;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid var(--accent-color);
    color: var(--text-primary);
}

.articles-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 1.5rem;
}

.article-card {
    background: var(--bg-card);
    border-radius: 8px;
    overflow: hidden;
    box-shadow: var(--shadow-sm);
    transition: transform 0.2s, box-shadow 0.2s;
}

.article-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.article-link {
    display: block;
    text-decoration: none;
    color: inherit;
}

.article-image {
    width: 100%;
    height: 200px;
    overflow: hidden;
    background: var(--bg-secondary);
}

.article-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.article-content {
    padding: 1rem;
}

.article-title {
    font-size: 1.125rem;
    font-weight: 600;
    line-height: 1.3;
    margin-bottom: 0.5rem;
    color: var(--text-primary);
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.article-excerpt {
    font-size: 0.875rem;
    line-height: 1.5;
    color: var(--text-secondary);
    margin-bottom: 0.75rem;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.article-meta {
    display: flex;
    justify-content: space-between;
    font-size: 0.75rem;
    color: var(--text-muted);
}

.view-all-news {
    text-align: center;
    margin: 3rem 0;
}

.btn {
    display: inline-block;
    padding: 0.75rem 2rem;
    background: var(--accent-color);
    color: white;
    text-decoration: none;
    border-radius: 4px;
    font-weight: 500;
    transition: background 0.2s;
}

.btn:hover {
    background: var(--accent-hover);
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .featured-title {
        font-size: 1.5rem;
    }
    
    .featured-excerpt {
        font-size: 1rem;
    }
    
    .featured-image {
        height: 250px;
    }
    
    .articles-grid {
        grid-template-columns: 1fr;
    }
}

@media (min-width: 769px) and (max-width: 1024px) {
    .articles-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}
</style>