<?php if ($pageType === 'home'): ?>
<!-- Hero Section -->
<section class="hero">
    <div class="container">
        <h1>Restaurant Health Inspection News</h1>
        <p>Real-time updates on food safety violations and closures</p>
    </div>
</section>
<?php endif; ?>

<!-- Main Content -->
<div class="container">
    <?php if (isset($showTags) && $showTags): ?>
        <!-- Topics Page Content -->
        <h1 style="margin: 32px 0;">Restaurant Inspection Topics</h1>
        
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">Locations</h2>
            </div>
            <div style="margin-bottom: 32px;">
                <a href="/tag/chicago" class="tag">Chicago</a>
                <a href="/tag/new-york" class="tag">New York</a>
                <a href="/tag/los-angeles" class="tag">Los Angeles</a>
                <a href="/tag/miami" class="tag">Miami</a>
                <a href="/tag/boston" class="tag">Boston</a>
                <a href="/tag/san-francisco" class="tag">San Francisco</a>
            </div>
        </div>
        
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">Restaurant Chains</h2>
            </div>
            <div style="margin-bottom: 32px;">
                <a href="/tag/mcdonalds" class="tag">McDonald's</a>
                <a href="/tag/subway" class="tag">Subway</a>
                <a href="/tag/chipotle" class="tag">Chipotle</a>
                <a href="/tag/portillos" class="tag">Portillo's</a>
                <a href="/tag/starbucks" class="tag">Starbucks</a>
            </div>
        </div>
        
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">Violation Types</h2>
            </div>
            <div style="margin-bottom: 32px;">
                <a href="/tag/temperature-violation" class="tag">Temperature Violations</a>
                <a href="/tag/rodent-activity" class="tag">Rodent Activity</a>
                <a href="/tag/hand-washing" class="tag">Hand Washing</a>
                <a href="/tag/closure" class="tag">Closures</a>
                <a href="/tag/sewage" class="tag">Sewage Issues</a>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if (isset($featuredArticle) && $featuredArticle): ?>
    <!-- Featured Article -->
    <article class="featured-article">
        <div class="featured-image">
            <img src="<?= getOptimizedImageUrl('', 'og', $featuredArticle) ?>" 
                 alt="Featured article" 
                 width="800" 
                 height="400"
                 class="image-loading"
                 onload="this.classList.remove('image-loading')">
        </div>
        <div class="featured-content">
            <span class="featured-badge">Breaking</span>
            <h2 class="article-title"><?= htmlspecialchars($featuredArticle['title']) ?></h2>
            <p class="article-meta"><?= $featuredArticle['city'] ?>, <?= $featuredArticle['state'] ?> • <?= timeAgo($featuredArticle['published_date']) ?></p>
            <p class="article-excerpt"><?= htmlspecialchars($featuredArticle['excerpt']) ?></p>
            <a href="/<?= $featuredArticle['slug'] ?>" class="article-link">Read full story →</a>
        </div>
    </article>
    <?php endif; ?>

    <!-- Recent Closures -->
    <section class="section">
        <div class="section-header">
            <h2 class="section-title">Recent Closures</h2>
        </div>
        <div class="row">
            <?php foreach ($recentClosures as $article): ?>
            <div class="col col-md-4">
                <article class="article-card">
                    <div class="article-image">
                        <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                             alt="Restaurant closure" 
                             width="400" 
                             height="200"
                             loading="lazy"
                             class="image-loading"
                             onload="this.classList.remove('image-loading')">
                    </div>
                    <div class="article-content">
                        <p class="article-meta"><?= $article['city'] ?>, <?= $article['state'] ?> • <?= timeAgo($article['published_date']) ?></p>
                        <h3 class="article-title"><?= htmlspecialchars($article['title']) ?></h3>
                        <p class="article-excerpt"><?= htmlspecialchars($article['excerpt']) ?></p>
                        <a href="/<?= $article['slug'] ?>" class="article-link">Continue reading →</a>
                    </div>
                </article>
            </div>
            <?php endforeach; ?>
        </div>
    </section>

    <!-- This Week Section -->
    <section class="section">
        <div class="section-header">
            <h2 class="section-title">This Week in Food Safety</h2>
        </div>
        <div class="row">
            <?php foreach ($weeklyArticles as $article): ?>
            <div class="col col-md-4">
                <article class="article-card">
                    <div class="article-image">
                        <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                             alt="Weekly report" 
                             width="400" 
                             height="200"
                             loading="lazy"
                             class="image-loading"
                             onload="this.classList.remove('image-loading')">
                    </div>
                    <div class="article-content">
                        <p class="article-meta"><?= $article['city'] ?><?= !empty($article['state']) ? ', ' . $article['state'] : '' ?><?= !empty($article['meta_label']) ? ' • ' . $article['meta_label'] : '' ?></p>
                        <h3 class="article-title"><?= htmlspecialchars($article['title']) ?></h3>
                        <p class="article-excerpt"><?= htmlspecialchars($article['excerpt']) ?></p>
                        <a href="/<?= $article['slug'] ?>" class="article-link">View report →</a>
                    </div>
                </article>
            </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>