<div class="container">
    <div class="static-content">
        <?php if ($staticPage === 'contact'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>Get in touch with the CleanKitchens editorial team for corrections, story suggestions, or general inquiries.</p>
            
            <h2>Report an Error</h2>
            <p>If you notice an error in our reporting, please email us at <a href="mailto:corrections@cleankitchens.com">corrections@cleankitchens.com</a> with:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Link to the article</li>
                <li>Description of the error</li>
                <li>Supporting documentation if available</li>
            </ul>
            
            <h2>Suggest a Story</h2>
            <p>Have a tip about restaurant health violations? Send it to <a href="mailto:tips@cleankitchens.com">tips@cleankitchens.com</a></p>
            <p>We protect our sources and appreciate community input on food safety issues.</p>
            
            <h2>Press Inquiries</h2>
            <p>Members of the media can contact us at <a href="mailto:press@cleankitchens.com">press@cleankitchens.com</a></p>
            
            <h2>General Inquiries</h2>
            <p>For all other questions, contact us at <a href="mailto:info@cleankitchens.com">info@cleankitchens.com</a></p>
            
            <h2>Mailing Address</h2>
            <p>
                CleanKitchens<br>
                [Address Line 1]<br>
                [City, State ZIP]
            </p>
            
        <?php elseif ($staticPage === 'about'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>CleanKitchens is a real-time restaurant health inspection news platform providing transparent, accurate reporting on food safety violations and restaurant closures across major US cities.</p>
            
            <h2>Our Founder</h2>
            <p><strong>Chris Nesbitt</strong> founded CleanKitchens with a unique combination of legal training and medical expertise that brings a distinctive perspective to public health data transparency:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li><strong>Legal Background:</strong> Graduate of Boston University's Paralegal Studies Program with focus on state regulatory compliance and public records law</li>
                <li><strong>Medical Expertise:</strong> Licensed Emergency Medical Provider in New Hampshire with firsthand experience in public health emergencies</li>
                <li><strong>Data Science Skills:</strong> Advanced training in computer coding with a focus on transforming complex datasets into accessible information</li>
            </ul>
            <p>This interdisciplinary background ensures a rigorous, ethical approach to health inspection data presentation that balances regulatory compliance, public health imperatives, and information accessibility.</p>
            
            <h2>Our Mission</h2>
            <p>We believe the public has a right to know about food safety issues in their communities. By transforming complex government inspection data into clear, accessible news stories, we help diners make informed decisions about where they eat.</p>
            
            <h2>What We Do</h2>
            <p>Every day, we:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Monitor official health department inspection data from Chicago and expanding cities</li>
                <li>Process over 295,000 inspection records to identify significant violations</li>
                <li>Verify information directly from government sources</li>
                <li>Publish timely, accurate news stories using AI-assisted journalism</li>
                <li>Track patterns across restaurant chains and locations</li>
            </ul>
            
            <h2>Our Data Sources</h2>
            <p>All information comes directly from official city and county health departments. We currently process data from:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li><strong>Chicago:</strong> Over 295,000 inspection records from the Chicago Department of Public Health</li>
                <li><strong>Additional Cities:</strong> Expanding coverage to major metropolitan areas</li>
            </ul>
            <p>We do not rely on user submissions or unverified sources. Our automated systems check for new inspection data multiple times daily.</p>
            
            <h2>Editorial Independence</h2>
            <p>CleanKitchens maintains complete editorial independence. We do not accept payment from restaurants for coverage decisions. Editorial decisions are never influenced by advertising or external pressure.</p>
            
            <h2>Our Commitment to Accuracy</h2>
            <p>We take accuracy seriously through:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Multiple source verification</li>
                <li>Automated data quality checks</li>
                <li>Editorial review processes</li>
                <li>Prompt corrections when errors are identified</li>
            </ul>
            <p>If you spot an error, please <a href="/contact">contact us</a> immediately. Corrections are posted promptly and transparently on our <a href="/corrections">corrections page</a>.</p>
            
        <?php elseif ($staticPage === 'search'): ?>
            <h1>Search</h1>
            
            <p>Search functionality coming soon. Use the navigation menu to browse by topics or view the latest articles.</p>
            
            <div style="margin-top: 32px;">
                <h2>Popular Topics</h2>
                <div style="margin-top: 16px;">
                    <a href="/tag/chicago" class="tag">Chicago</a>
                    <a href="/tag/closure" class="tag">Closures</a>
                    <a href="/tag/rodent-activity" class="tag">Rodent Activity</a>
                    <a href="/tag/temperature-violation" class="tag">Temperature Violations</a>
                </div>
            </div>
            
        <?php elseif ($staticPage === 'methodology'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>CleanKitchens employs rigorous methodologies to ensure accurate, timely, and meaningful presentation of health inspection data.</p>
            
            <h2>Data Collection</h2>
            <p>We collect health inspection data through multiple channels:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li><strong>API Integration:</strong> Direct connections to government health department APIs for real-time data access</li>
                <li><strong>Open Data Portals:</strong> Regular downloads from municipal and state open data platforms</li>
                <li><strong>Public Records Requests:</strong> FOIA requests for jurisdictions without digital access</li>
                <li><strong>Automated Scraping:</strong> Ethical web scraping of publicly available inspection records</li>
            </ul>
            
            <h2>Data Processing</h2>
            <p>Our data processing pipeline ensures consistency and accuracy:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Standardization of violation categories across different jurisdictions</li>
                <li>Normalization of scoring systems for meaningful comparisons</li>
                <li>Deduplication to prevent repeated reporting of the same violations</li>
                <li>Verification against multiple sources when available</li>
                <li>Quality checks for data completeness and accuracy</li>
            </ul>
            
            <h2>Article Generation</h2>
            <p>Our news articles are created using a combination of automated and editorial processes:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Automated identification of newsworthy violations and closures</li>
                <li>Contextual analysis of violation severity and public health impact</li>
                <li>Historical pattern detection for repeat offenders</li>
                <li>Editorial review for accuracy and clarity</li>
                <li>Regular updates as new information becomes available</li>
            </ul>
            
            <h2>Scoring Normalization</h2>
            <p>Different jurisdictions use various scoring systems. We normalize these for comparison:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Letter grades (A, B, C) converted to numerical scores</li>
                <li>Point-based systems standardized to 0-100 scale</li>
                <li>Pass/Fail results supplemented with violation details</li>
                <li>Critical violations weighted more heavily than minor infractions</li>
            </ul>
            
            <h2>Update Frequency</h2>
            <p>Data freshness varies by source:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>API-connected sources: Updated every 4-6 hours</li>
                <li>Open data portals: Updated daily</li>
                <li>Scraped sources: Updated weekly</li>
                <li>FOIA requests: Updated monthly or as received</li>
            </ul>
            
        <?php elseif ($staticPage === 'editorial-policy'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>CleanKitchens maintains strict editorial standards to ensure fair, accurate, and responsible reporting of health inspection data.</p>
            
            <h2>Core Principles</h2>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li><strong>Accuracy First:</strong> We prioritize factual accuracy over speed of publication</li>
                <li><strong>Public Interest:</strong> We focus on violations that pose genuine public health risks</li>
                <li><strong>Fairness:</strong> We report violations objectively without sensationalism</li>
                <li><strong>Transparency:</strong> We clearly identify our sources and methods</li>
                <li><strong>Independence:</strong> Editorial decisions are never influenced by advertising or external pressure</li>
            </ul>
            
            <h2>What We Report</h2>
            <p>We prioritize reporting on:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Restaurant closures due to health violations</li>
                <li>Critical violations that pose immediate health risks</li>
                <li>Repeat violations showing patterns of non-compliance</li>
                <li>Major chains with widespread issues</li>
                <li>Violations at high-traffic establishments</li>
            </ul>
            
            <h2>What We Don't Report</h2>
            <p>We generally do not report on:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Minor violations quickly corrected during inspection</li>
                <li>Administrative issues unrelated to food safety</li>
                <li>Isolated incidents at otherwise compliant establishments</li>
                <li>Violations at permanently closed establishments</li>
            </ul>
            
            <h2>Verification Standards</h2>
            <p>Before publication, we verify:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Data accuracy against official government sources</li>
                <li>Restaurant identity and current operating status</li>
                <li>Violation severity and classification</li>
                <li>Timeline of events and follow-up inspections</li>
            </ul>
            
            <h2>Right of Response</h2>
            <p>While we report on public records, we recognize restaurants' right to provide context. Establishments mentioned in our reporting may contact us to:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Report factual errors for correction</li>
                <li>Provide updates on corrective actions taken</li>
                <li>Share context about unusual circumstances</li>
            </ul>
            
            <h2>Corrections and Updates</h2>
            <p>When errors are identified:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Corrections are made promptly and transparently</li>
                <li>Original text is struck through, not deleted</li>
                <li>Correction notices are added to the top of articles</li>
                <li>Significant corrections are noted on our corrections page</li>
            </ul>
            
        <?php elseif ($staticPage === 'corrections'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>CleanKitchens is committed to accuracy in all our reporting. When errors occur, we correct them promptly and transparently.</p>
            
            <h2>How to Report an Error</h2>
            <p>If you believe we've published incorrect information:</p>
            <ol style="margin-bottom: 24px; padding-left: 24px;">
                <li>Email us at <a href="mailto:corrections@cleankitchens.com">corrections@cleankitchens.com</a></li>
                <li>Include the article URL and specific error</li>
                <li>Provide supporting documentation if available</li>
                <li>We'll review and respond within 24 hours</li>
            </ol>
            
            <h2>Our Correction Process</h2>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Errors are reviewed by our editorial team</li>
                <li>Corrections are made to the original article</li>
                <li>A correction notice is added to the article</li>
                <li>Major corrections are listed on this page</li>
                <li>We notify readers who may have been affected</li>
            </ul>
            
            <h2>Types of Corrections</h2>
            <p><strong>Minor Corrections:</strong> Spelling errors, typos, or minor factual details that don't change the substance of the story.</p>
            <p><strong>Major Corrections:</strong> Factual errors that affect the understanding or interpretation of the story.</p>
            <p><strong>Clarifications:</strong> Additional context or information that helps readers better understand the story.</p>
            <p><strong>Updates:</strong> New information that has become available since publication.</p>
            
            <h2>Recent Corrections</h2>
            <p><em>No corrections have been issued in the past 30 days.</em></p>
            
            <h2>Commitment to Accuracy</h2>
            <p>We take every effort to ensure accuracy before publication through:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Multiple source verification</li>
                <li>Automated data quality checks</li>
                <li>Editorial review processes</li>
                <li>Regular audits of our reporting</li>
            </ul>
            
        <?php elseif ($staticPage === 'disclaimer'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <div style="background: #fff3cd; border: 2px solid #ffc107; padding: 1.5rem; border-radius: 4px; margin-bottom: 2rem;">
                <p style="margin: 0 0 1rem 0; font-weight: bold; color: #856404;">
                    IMPORTANT: This website reports on HISTORICAL health inspection data obtained from government sources at the time of inspection. 
                    Conditions may have changed significantly since the inspection date. Many establishments correct violations immediately. 
                    Always verify current status directly with the establishment or local health department before making any decisions.
                </p>
                <p style="margin: 0; color: #856404;">
                    <strong>Automated Content:</strong> Articles on this site are automatically generated based on government inspection data. 
                    If you find a factual error, please <a href="/contact" style="color: #856404; text-decoration: underline;">notify us</a> 
                    and we will work to correct it promptly.
                </p>
            </div>
            
            <p>The information provided on CleanKitchens.org is for general informational and educational purposes only.</p>
            
            <h2>Historical Data Notice</h2>
            <p><strong>All inspection reports on this site represent conditions at a specific point in time and may not reflect current conditions.</strong> Establishments frequently:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Correct violations immediately after inspection</li>
                <li>Pass re-inspections shortly after initial inspection</li>
                <li>Implement new safety procedures</li>
                <li>Change management or ownership</li>
                <li>Undergo renovations or improvements</li>
            </ul>
            
            <h2>No Warranty or Liability</h2>
            <p>While we strive to accurately report government inspection data, we make no representations or warranties of any kind, express or implied, about the completeness, accuracy, reliability, suitability, or availability of the information, products, services, or related graphics contained on this website.</p>
            
            <h2>Data Sources</h2>
            <p>All health inspection data is sourced from government agencies. We do not conduct inspections ourselves and cannot independently verify the accuracy of government data. Inspection results may be subject to:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Reporting delays</li>
                <li>Data entry errors</li>
                <li>Administrative updates</li>
                <li>Appeals and corrections</li>
                <li>Variations in inspection standards</li>
            </ul>
            
            <h2>Not Professional Advice</h2>
            <p>The information on CleanKitchens.org should not be considered as professional advice:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li><strong>Not Medical Advice:</strong> We do not provide medical or health advice</li>
                <li><strong>Not Legal Advice:</strong> We do not provide legal interpretation of regulations</li>
                <li><strong>Not Business Advice:</strong> We do not advise on business operations or compliance</li>
            </ul>
            
            <h2>External Links</h2>
            <p>This website may contain links to external websites that are not provided or maintained by CleanKitchens. We do not guarantee the accuracy, relevance, timeliness, or completeness of any information on these external websites.</p>
            
            <h2>Limitation of Liability</h2>
            <p>In no event will CleanKitchens be liable for any loss or damage including without limitation, indirect or consequential loss or damage, or any loss or damage whatsoever arising from the use of this website.</p>
            
            <h2>Restaurant Status</h2>
            <p>Restaurant inspection results and operational status can change rapidly. Always verify current status directly with the establishment or local health department before making decisions based on our reporting.</p>
            
            <h2>Fair Use</h2>
            <p>Information on this site may be used for personal, non-commercial purposes with appropriate attribution. Commercial use or systematic downloading of content is prohibited without written permission.</p>
            
            <h2>Contact Information</h2>
            <p>Questions about this disclaimer should be directed to <a href="mailto:legal@cleankitchens.com">legal@cleankitchens.com</a></p>
            
        <?php elseif ($staticPage === 'privacy'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>Effective Date: <?php echo date('F j, Y'); ?></p>
            
            <p>CleanKitchens.org respects your privacy. This policy explains how we collect, use, and protect your information.</p>
            
            <h2>Information We Collect</h2>
            <p>We collect information in the following ways:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li><strong>Automatically Collected:</strong> IP address, browser type, device information, pages visited, time spent on pages</li>
                <li><strong>Cookies:</strong> Small files stored on your device to improve user experience</li>
                <li><strong>Voluntarily Provided:</strong> Email address if you subscribe to our newsletter or contact us</li>
            </ul>
            
            <h2>How We Use Your Information</h2>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>To provide and improve our services</li>
                <li>To analyze website usage and optimize performance</li>
                <li>To send newsletters (only if you opt-in)</li>
                <li>To respond to your inquiries</li>
                <li>To detect and prevent fraud or abuse</li>
            </ul>
            
            <h2>Data Sharing</h2>
            <p>We do not sell, rent, or trade your personal information. We may share data with:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Service providers who help operate our website</li>
                <li>Law enforcement when required by law</li>
                <li>Third parties with your explicit consent</li>
            </ul>
            
            <h2>Data Security</h2>
            <p>We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p>
            
            <h2>Your Rights</h2>
            <p>You have the right to:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Access the personal information we hold about you</li>
                <li>Request correction of inaccurate information</li>
                <li>Request deletion of your information</li>
                <li>Opt-out of marketing communications</li>
                <li>Disable cookies through your browser settings</li>
            </ul>
            
            <h2>Children's Privacy</h2>
            <p>CleanKitchens.org is not directed to children under 13. We do not knowingly collect personal information from children.</p>
            
            <h2>Changes to This Policy</h2>
            <p>We may update this privacy policy from time to time. Changes will be posted on this page with an updated effective date.</p>
            
            <h2>Contact Us</h2>
            <p>For privacy-related questions, contact us at <a href="mailto:privacy@cleankitchens.com">privacy@cleankitchens.com</a></p>
            
        <?php elseif ($staticPage === 'terms'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>Effective Date: <?php echo date('F j, Y'); ?></p>
            
            <p>By accessing or using CleanKitchens.org, you agree to be bound by these Terms of Service.</p>
            
            <h2>Acceptance of Terms</h2>
            <p>By using this website, you acknowledge that you have read, understood, and agree to be bound by these terms. If you do not agree, you must not use this website.</p>
            
            <h2>Use of Service</h2>
            <p>You may use CleanKitchens.org for lawful purposes only. You agree not to:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Violate any applicable laws or regulations</li>
                <li>Infringe on the rights of others</li>
                <li>Interfere with or disrupt the service</li>
                <li>Attempt unauthorized access to any part of the service</li>
                <li>Use automated tools to scrape or download content without permission</li>
                <li>Misrepresent information obtained from our service</li>
            </ul>
            
            <h2>Intellectual Property</h2>
            <p>All content on CleanKitchens.org, including text, graphics, logos, and images, is protected by copyright and other intellectual property laws. You may not reproduce, distribute, or create derivative works without our written permission.</p>
            
            <h2>Information Disclaimer</h2>
            <p>Information on CleanKitchens.org is provided "as is" without warranty of any kind. We source data from government agencies but cannot guarantee its accuracy or completeness. Users should verify critical information independently.</p>
            
            <h2>Limitation of Liability</h2>
            <p>CleanKitchens.org shall not be liable for any direct, indirect, incidental, special, consequential, or punitive damages arising from your use of this service or reliance on information provided.</p>
            
            <h2>Indemnification</h2>
            <p>You agree to indemnify and hold harmless CleanKitchens.org and its affiliates from any claims, damages, or expenses arising from your use of the service or violation of these terms.</p>
            
            <h2>Third-Party Links</h2>
            <p>Our website may contain links to third-party websites. We are not responsible for the content, privacy policies, or practices of these external sites.</p>
            
            <h2>Modifications</h2>
            <p>We reserve the right to modify these terms at any time. Continued use of the service after changes constitutes acceptance of the modified terms.</p>
            
            <h2>Termination</h2>
            <p>We may terminate or suspend access to our service immediately, without prior notice, for any breach of these Terms of Service.</p>
            
            <h2>Governing Law</h2>
            <p>These terms shall be governed by and construed in accordance with the laws of the State of New Hampshire, without regard to its conflict of law provisions.</p>
            
            <h2>Contact Information</h2>
            <p>For questions about these Terms of Service, contact us at <a href="mailto:legal@cleankitchens.com">legal@cleankitchens.com</a></p>
            
        <?php endif; ?>
    </div>
</div>