<!-- Tag Page Template -->
<div class="container">
    <div class="static-content">
        <h1><?= htmlspecialchars($pageData['h1']) ?></h1>
        
        <!-- Tag Overview (Claude-generated content) -->
        <div class="tag-overview">
            <?= $pageData['overview_content'] ?>
        </div>
        
        <!-- Tag Statistics -->
        <div class="tag-stats" style="background: var(--bg-card); padding: 1.5rem; border-radius: 8px; margin: 2rem 0; border: 1px solid var(--border-color);">
            <h2 style="margin-top: 0; font-size: 1.25rem; color: var(--text-primary);">Statistics</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem;">
                <div>
                    <strong>Total Articles:</strong> <?= number_format($tagStats['article_count']) ?>
                </div>
                <div>
                    <strong>Date Range:</strong> <?= $tagStats['date_range'] ?>
                </div>
                <div>
                    <strong>Most Recent:</strong> <?= $tagStats['most_recent'] ?>
                </div>
                <?php if (isset($tagStats['common_violations'])): ?>
                <div>
                    <strong>Common Issues:</strong> <?= implode(', ', $tagStats['common_violations']) ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Related Tags -->
        <?php if (!empty($relatedTags)): ?>
        <div class="related-tags" style="margin: 2rem 0;">
            <h2>Related Topics</h2>
            <div class="tag-cloud">
                <?php foreach ($relatedTags as $tag): ?>
                <a href="/tag/<?= $tag['slug'] ?>" class="tag" style="display: inline-block; background: var(--accent-color); color: white; padding: 0.5rem 1rem; margin: 0.25rem; border-radius: 20px; text-decoration: none; font-size: 0.875rem;"><?= htmlspecialchars($tag['name']) ?></a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Articles List -->
        <div class="tagged-articles">
            <h2>All <?= htmlspecialchars($pageData['tag_name'] ?? 'Tag') ?> Articles</h2>
            <!-- Get articles directly if not set -->
            <?php
            if (!isset($taggedArticles) || empty($taggedArticles)) {
                $taggedArticles = getArticlesByTag($pageData['tag_name'] ?? 'rodent', 50);
            }
            ?>
            <?php if (!empty($taggedArticles) && is_array($taggedArticles)): ?>
            <div class="articles-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1.5rem; margin-top: 1.5rem;">
                <?php foreach ($taggedArticles as $article): ?>
                <article class="article-card" style="background: var(--bg-card); border-radius: 8px; overflow: hidden; box-shadow: var(--shadow-sm); transition: transform 0.2s, box-shadow 0.2s;">
                    <a href="/<?= htmlspecialchars($article['slug']) ?>" style="display: block; text-decoration: none; color: inherit;">
                        <?php if (!empty($article['image_url'])): ?>
                        <div class="article-image" style="width: 100%; height: 200px; overflow: hidden; background: var(--bg-secondary);">
                            <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                                 alt="<?= htmlspecialchars($article['establishment_name'] ?? 'Restaurant inspection') ?>"
                                 loading="lazy"
                                 width="300"
                                 height="200"
                                 style="width: 100%; height: 100%; object-fit: cover;">
                        </div>
                        <?php endif; ?>
                        <div class="article-content" style="padding: 1rem;">
                            <h3 style="font-size: 1.125rem; font-weight: 600; line-height: 1.3; margin-bottom: 0.5rem; color: var(--text-primary);"><?= htmlspecialchars($article['title']) ?></h3>
                            <?php if (!empty($article['excerpt'])): ?>
                            <p style="font-size: 0.875rem; line-height: 1.5; color: var(--text-secondary); margin-bottom: 0.75rem;"><?= htmlspecialchars(substr($article['excerpt'], 0, 120)) ?>...</p>
                            <?php endif; ?>
                            <div style="display: flex; justify-content: space-between; font-size: 0.75rem; color: var(--text-muted);">
                                <span><?= htmlspecialchars($article['city']) ?>, <?= htmlspecialchars($article['state']) ?></span>
                                <span><?= htmlspecialchars($article['formatted_time']) ?></span>
                            </div>
                        </div>
                    </a>
                </article>
                <?php endforeach; ?>
            </div>
            <?php else: ?>
            <div style="text-align: center; padding: 2rem; color: var(--text-secondary);">
                <p>No articles found for this tag.</p>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Pagination -->
        <?php if ($totalPages > 1): ?>
        <div class="pagination" style="text-align: center; margin: 3rem 0;">
            <?php if ($currentPage > 1): ?>
                <a href="/tag/<?= $tagSlug ?>?page=<?= $currentPage - 1 ?>" style="margin: 0 0.5rem; padding: 0.5rem 1rem; background: var(--accent-color); color: white; text-decoration: none; border-radius: 4px;">&larr; Previous</a>
            <?php endif; ?>
            
            <span style="margin: 0 1rem;">Page <?= $currentPage ?> of <?= $totalPages ?></span>
            
            <?php if ($currentPage < $totalPages): ?>
                <a href="/tag/<?= $tagSlug ?>?page=<?= $currentPage + 1 ?>" style="margin: 0 0.5rem; padding: 0.5rem 1rem; background: var(--accent-color); color: white; text-decoration: none; border-radius: 4px;">Next &rarr;</a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <!-- SEO Content Footer -->
        <div class="tag-footer" style="margin-top: 3rem; padding-top: 2rem; border-top: 1px solid var(--border-color); font-size: 0.875rem; color: var(--text-secondary);">
            <p>This page aggregates all CleanKitchens articles tagged with "<?= htmlspecialchars($pageData['tag_name']) ?>". Our automated system tracks patterns and trends in restaurant health inspections to help consumers make informed dining decisions.</p>
            
            <?php if (($pageData['tag_type'] ?? '') === 'chain'): ?>
            <p><strong>About Chain Restaurant Monitoring:</strong> We track health inspection results across all <?= htmlspecialchars($pageData['tag_name']) ?> locations to identify trends and patterns that may indicate systemic issues.</p>
            <?php elseif (($pageData['tag_type'] ?? '') === 'violation'): ?>
            <p><strong>About <?= htmlspecialchars($pageData['tag_name']) ?> Violations:</strong> Understanding common violation types helps consumers and restaurant operators improve food safety practices.</p>
            <?php elseif (($pageData['tag_type'] ?? '') === 'location'): ?>
            <p><strong>About <?= htmlspecialchars($pageData['tag_name']) ?> Area Inspections:</strong> Local health department inspection results for restaurants in the <?= htmlspecialchars($pageData['tag_name']) ?> area.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
/* Tag page specific styles */
.tag-overview {
    font-size: 1.125rem;
    line-height: 1.6;
    margin: 1.5rem 0 2rem;
    color: var(--text-primary);
}

.article-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

@media (max-width: 768px) {
    .articles-grid {
        grid-template-columns: 1fr;
    }
    
    .tag-stats {
        padding: 1rem;
    }
    
    .tag-stats > div {
        grid-template-columns: 1fr;
    }
}
</style>