<?php
require_once 'includes/config.php';
require_once 'functions_live.php';

$slug = "2025/08/16/chicago-restaurant-fails-inspection-putting-diners-at-risk";

echo "<h2>Testing Article Retrieval</h2>";
echo "<p>Looking for slug: <code>$slug</code></p>";

$article = getArticleBySlugFromDB($slug);

if ($article) {
    echo "<h3>✅ Article Found!</h3>";
    echo "<p>Title: " . $article['title'] . "</p>";
    echo "<p>City: " . $article['city'] . "</p>";
    echo "<p>Content length: " . strlen($article['content']) . " chars</p>";
} else {
    echo "<h3>❌ Article Not Found</h3>";
    
    // Let's check what slugs exist
    $query = '{
        Get {
            Articles(limit: 5) {
                slug
                title
            }
        }
    }';
    
    $response = queryWeaviate($query);
    if ($response && isset($response['data']['Get']['Articles'])) {
        echo "<h4>Available slugs:</h4>";
        foreach ($response['data']['Get']['Articles'] as $art) {
            echo "<code>" . $art['slug'] . "</code><br>";
        }
    }
}
?>