<?php
// Analytics tracking endpoint
header('Content-Type: application/json');

// Get tracking data
$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
    // Fallback to GET parameters for pixel tracking
    $data = [
        'type' => $_GET['type'] ?? 'pageview',
        'url' => $_GET['url'] ?? $_SERVER['HTTP_REFERER'] ?? '',
        'article_id' => $_GET['article_id'] ?? null,
        'referrer' => $_GET['ref'] ?? $_SERVER['HTTP_REFERER'] ?? ''
    ];
}

// Add server-side data
$data['timestamp'] = date('Y-m-d H:i:s');
$data['ip'] = $_SERVER['REMOTE_ADDR'] ?? '';
$data['user_agent'] = $_SERVER['HTTP_USER_AGENT'] ?? '';
$data['session_id'] = session_id() ?: uniqid('anon_');

// Determine device type
$userAgent = strtolower($data['user_agent']);
if (strpos($userAgent, 'mobile') !== false || strpos($userAgent, 'android') !== false || strpos($userAgent, 'iphone') !== false) {
    $data['device'] = 'mobile';
} elseif (strpos($userAgent, 'tablet') !== false || strpos($userAgent, 'ipad') !== false) {
    $data['device'] = 'tablet';
} else {
    $data['device'] = 'desktop';
}

// Parse referrer for traffic source
$referrer = parse_url($data['referrer'], PHP_URL_HOST);
if (!$referrer || $referrer === $_SERVER['HTTP_HOST']) {
    $data['source'] = 'direct';
} elseif (strpos($referrer, 'google') !== false) {
    $data['source'] = 'google';
} elseif (strpos($referrer, 'facebook') !== false || strpos($referrer, 'twitter') !== false || strpos($referrer, 'instagram') !== false) {
    $data['source'] = 'social';
} else {
    $data['source'] = 'referral';
}

// Store in analytics log file (could be database in production)
$logFile = __DIR__ . '/admin/analytics/analytics_' . date('Y-m-d') . '.json';
$logDir = dirname($logFile);
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}

// Append to daily log
$logEntry = json_encode($data) . "\n";
file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);

// Return success
echo json_encode(['status' => 'success', 'tracked' => true]);
?>