<?php
// SIMPLE ARTICLE VIEWER - Gets slug from URL parameter
require_once 'includes/config.php';
require_once 'functions_live.php';

// Get the slug from URL
$slug = isset($_GET['slug']) ? $_GET['slug'] : '';

if (empty($slug)) {
    // No slug provided - redirect to homepage
    header("Location: /");
    exit;
}

// Try to get article from database
$article = getArticleBySlugFromDB($slug);

if (!$article) {
    // Article not found - show 404
    header("HTTP/1.0 404 Not Found");
    $pageTitle = "Article Not Found - CleanKitchens";
    $pageDescription = "The requested article was not found.";
    
    include 'includes/head.php';
    include 'includes/nav.php';
    echo '<main id="main-content"><div class="container"><div class="static-content">';
    echo '<h1>Article Not Found</h1>';
    echo '<p>Sorry, the article you are looking for could not be found.</p>';
    echo '<p><a href="/">Return to Homepage</a></p>';
    echo '</div></div></main>';
    include 'includes/footer.php';
    exit;
}

// Article found - display it
$relatedArticles = getRelatedArticlesFromDB();

include 'includes/head.php';
include 'includes/nav.php';
?>

<main id="main-content">
    <?php include 'templates/article.php'; ?>
</main>

<?php include 'includes/footer.php'; ?>