<?php

/**

 * Contact Page Template - Fully Optimized for Performance

 */



// Include header (which loads config.php)

include(BASE_PATH . '/app/Views/components/header.php');

?>



<!-- Optimized for minimal LCP and render blocking -->

<div class="container">

    <div class="row">

        <div class="col-lg-8 col-md-10 mx-auto">

            <!-- Above-the-fold content with inline styles -->

            <div style="min-height:250px;padding-top:20px;"> <!-- Generous height reservation for all above-fold content -->

                <!-- First priority content -->

                <h1 style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:2.5rem;font-weight:500;line-height:1.2;text-align:center;margin:20px auto 24px;padding:0;color:#212529;max-width:100%;display:block;border:none;background:none;">Contact SoberList</h1>

                

                <p id="lcp-element" style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;font-size:1.25rem;font-weight:400;line-height:1.5;text-align:center;margin:0 auto 2rem;max-width:800px;color:#212529;">

                    We're here to help. Reach out with any questions about our services.

                </p>

            </div>

            

            <!-- Below-the-fold content - no need for inline optimization -->

            <div class="contact-methods mb-5">

                <div class="row">

                    <!-- Contact Info Section -->

                    <div class="col-md-6 mb-4">

                        <div class="contact-info p-4 bg-light rounded">

                            <h2 class="mb-4">Get In Touch</h2>

                            <p>Have questions about SoberList? We're here to help. Reach out through any of these channels:</p>

                            

                            <div class="contact-item d-flex align-items-center mb-3">

                                <div class="icon-container me-3">

                                    <i class="bi bi-envelope fs-4 text-primary"></i>

                                </div>

                                <div>

                                    <h3 class="h5 mb-1">Email Us</h3>

                                    <p class="mb-0"><a href="mailto:info@soberlist.org">info@soberlist.org</a></p>

                                </div>

                            </div>

                            

                            <div class="contact-item d-flex align-items-center mb-3">

                                <div class="icon-container me-3">

                                    <i class="bi bi-telephone fs-4 text-primary"></i>

                                </div>

                                <div>

                                    <h3 class="h5 mb-1">Call Us</h3>

                                    <p class="mb-0"><a href="tel:+18885017071">(888) 501-7071</a></p>

                                </div>

                            </div>

                            

                            <div class="contact-hours mt-4">

                                <h3 class="h5">Hours of Operation</h3>

                                <p>Our support team is available Monday through Friday, 9:00 AM to 5:00 PM EST.</p>

                            </div>

                        </div>

                    </div>

                    

                    

                </div>

            </div>

        </div>

    </div>

</div>



<?php

// Include footer

include(BASE_PATH . '/app/Views/components/footer.php');

?>



<!-- Bootstrap JS for accordion functionality -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous" defer></script>