<?php

/**

 * Facility Page Template - SoberList.org

 * Uses standard header/footer with facility-specific content

 */



// Include facility logic (which loads facility data)

require_once(BASE_PATH . '/app/Views/pages/facility/facility.php');



// Include config (which handles meta tags and schema)

require_once(BASE_PATH . '/app/Views/pages/facility/config.php');



// Now set canonical URL after all functions are available

$canonical_url = $base_url . '/facility/' . generate_facility_url($facility);



// Include standard header

include(BASE_PATH . '/app/Views/components/header.php');

?>



<!-- Breadcrumb section -->

<div class="breadcrumbs bg-light py-2">

  

        <?php include_once BASE_PATH . '/app/Views/components/breadcrumbs.php'; ?>

 

</div>



<section class="facility-detail py-5">

    <div class="container">

        <div class="row mb-4">

            <div class="col-md-3 col-sm-12 mb-3 mb-md-0">

                <img src="<?php echo htmlspecialchars($image_info['path']); ?>" 

                     class="facility-main-image rounded" 

                     alt="<?php echo htmlspecialchars($image_info['alt']); ?>"

                     width="<?php echo $image_info['width']; ?>" 

                     height="<?php echo $image_info['height']; ?>"

                     loading="eager">

                     

                <!-- Map image - visible only on desktop -->

                <!-- Map image - visible only on desktop -->

                <a href="https://maps.google.com/maps?q=<?php echo urlencode($facility['address_line1'] . ' ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&api=1&navigate=yes" 

                   target="_blank" rel="noopener" class="map-link d-none d-md-block mt-3">

                    <div class="facility-map-container">

                        <?php 

                        // Only show map if API key is configured properly

                        $mapApiKey = defined('GOOGLE_MAPS_API_KEY') ? GOOGLE_MAPS_API_KEY : '';

                        if ($mapApiKey && $mapApiKey !== 'YOUR_GOOGLE_MAPS_API_KEY'):

                        ?>

                        <img src="https://maps.googleapis.com/maps/api/staticmap?center=<?php echo urlencode($facility['address_line1'] . ', ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&zoom=14&size=250x250&scale=1&markers=color:red%7C<?php echo urlencode($facility['address_line1'] . ', ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&key=<?php echo $mapApiKey; ?>"

                             alt="Map showing location of <?php echo htmlspecialchars($facility['name']); ?>"

                             class="facility-map-image rounded"

                             width="250"

                             height="250"

                             loading="lazy">

                        <?php else: ?>

                        <div class="map-placeholder">

                            <div class="text-center p-4 bg-light">

                                <i class="bi bi-map fs-2 text-secondary"></i>

                                <p class="mt-2 mb-0">Click for directions</p>

                            </div>

                        </div>

                        <?php endif; ?>

                    </div>

                </a>

            </div>

            <div class="col-md-9 col-sm-12">

                <h1 class="display-5 mb-3"><?php echo htmlspecialchars($facility['name']); ?></h1>

                

                <!-- Overview section -->

                <h2 class="h4 mb-3">Overview</h2>

                

                <?php if (!empty($facility['description'])): ?>

                    <p class="lead"><?php echo htmlspecialchars(substr(strip_tags($facility['description']), 0, 250)) . (strlen($facility['description']) > 250 ? '...' : ''); ?></p>

                <?php else: ?>

                    <p class="lead"><?php echo htmlspecialchars($meta_description); ?></p>

                <?php endif; ?>

                

                <hr>

                    

                <div class="facility-contact-info card mb-3">

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">

                                <div class="d-flex align-items-start mb-3">

                                    <i class="bi bi-geo-alt-fill text-primary me-3 fs-4"></i>

                                    <div>

                                        <h3 class="h6 mb-1">Address</h3>

                                        <p class="mb-2">

                                            <?php echo htmlspecialchars($facility['address_line1']); ?>

                                            <?php if (!empty($facility['address_line2'])): ?>

                                                <br><?php echo htmlspecialchars($facility['address_line2']); ?>

                                            <?php endif; ?>

                                            <br><?php echo htmlspecialchars($facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>

                                        </p>

                                        <a href="https://maps.google.com/maps?q=<?php echo urlencode($facility['address_line1'] . ' ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&api=1&navigate=yes" 

                                           target="_blank" rel="noopener" class="btn btn-secondary btn-sm">

                                            <i class="bi bi-geo-alt-fill me-1"></i> Get Directions

                                        </a>

                                    </div>

                                </div>

                            </div>

                            

                            <?php if (!empty($facility['phone'])): ?>

                            <div class="col-md-6">

                                <div class="d-flex align-items-start mb-3">

                                    <i class="bi bi-telephone-fill text-primary me-3 fs-4"></i>

                                    <div>

                                        <h3 class="h6 mb-1">Phone</h3>

                                        <p class="mb-2">

                                            <?php echo format_phone($facility['phone']); ?>

                                        </p>

                                        <a href="tel:<?php echo preg_replace('/[^0-9]/', '', $facility['phone']); ?>" class="btn btn-success btn-sm">

                                            <i class="bi bi-telephone-fill me-1"></i> Call Now

                                        </a>

                                    </div>

                                </div>

                            </div>

                            <?php endif; ?>

                        </div>

                        

                        <div class="row mt-3">

                            <?php if (!empty($facility['website'])): ?>

                            <div class="col-md-6">

                                <div class="d-flex align-items-start mb-3">

                                    <i class="bi bi-globe2 text-primary me-3 fs-4"></i>

                                    <div>

                                        <h3 class="h6 mb-1">Website</h3>

                                        <p class="mb-2">

                                            <?php echo preg_replace('#^https?://#', '', htmlspecialchars($facility['website'])); ?>

                                        </p>

                                        <a href="<?php echo htmlspecialchars($facility['website']); ?>" target="_blank" rel="noopener" class="btn btn-primary btn-sm">

                                            <i class="bi bi-globe2 me-1"></i> Visit Website

                                        </a>

                                    </div>

                                </div>

                            </div>

                            <?php endif; ?>

                            

                            <?php if (!empty($facility['email'])): ?>

                            <div class="col-md-6">

                                <div class="d-flex align-items-start mb-3">

                                    <i class="bi bi-envelope-fill text-primary me-3 fs-4"></i>

                                    <div>

                                        <h3 class="h6 mb-1">Email</h3>

                                        <p class="mb-2">

                                            <?php echo htmlspecialchars($facility['email']); ?>

                                        </p>

                                        <a href="mailto:<?php echo htmlspecialchars($facility['email']); ?>" class="btn btn-primary btn-sm">

                                            <i class="bi bi-envelope-fill me-1"></i> Send Email

                                        </a>

                                    </div>

                                </div>

                            </div>

                            <?php endif; ?>

                        </div>

                        

                        <!-- Main action buttons are removed as requested -->

                        

                        <!-- Map image - visible only on mobile -->

                        <div class="facility-image-container d-md-none mt-4">

                            <a href="https://maps.google.com/maps?q=<?php echo urlencode($facility['address_line1'] . ' ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&api=1&navigate=yes" 

                               target="_blank" rel="noopener" class="map-link">

                                <div class="facility-map-container">

                                    <?php 

                                    // Only show map if API key is configured properly

                                    $mapApiKey = defined('GOOGLE_MAPS_API_KEY') ? GOOGLE_MAPS_API_KEY : '';

                                    if ($mapApiKey && $mapApiKey !== 'YOUR_GOOGLE_MAPS_API_KEY'):

                                    ?>

                                    <img src="https://maps.googleapis.com/maps/api/staticmap?center=<?php echo urlencode($facility['address_line1'] . ', ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&zoom=14&size=400x400&scale=1&markers=color:red%7C<?php echo urlencode($facility['address_line1'] . ', ' . $facility['city'] . ', ' . $facility['state_code'] . ' ' . $facility['zip_code']); ?>&key=<?php echo $mapApiKey; ?>"

                                         alt="Map showing location of <?php echo htmlspecialchars($facility['name']); ?>"

                                         class="facility-map-image rounded" 

                                         width="<?php echo $image_info['width']; ?>" 

                                         height="<?php echo $image_info['height']; ?>"

                                         loading="lazy">

                                    <?php else: ?>

                                    <div class="map-placeholder">

                                        <div class="text-center p-4 bg-light">

                                            <i class="bi bi-map fs-2 text-secondary"></i>

                                            <p class="mt-2 mb-0">Click for directions</p>

                                        </div>

                                    </div>

                                    <?php endif; ?>

                                    <div class="map-overlay">

                                        <div class="tap-for-directions">Tap to get directions</div>

                                    </div>

                                </div>

                            </a>

                        </div>

                    </div>

                </div>

            </div>

        </div>

            

        <div class="facility-details mb-4">

            <div class="row">

                <div class="col-lg-4 col-md-6 mb-4">

                    <div class="info-card">

                        <h3 class="info-card-title">

                            <i class="bi bi-clipboard2-check info-card-icon"></i>Care Types

                        </h3>

                        <?php if (!empty($care_types)): ?>

                            <ul>

                                <?php foreach ($care_types as $type): ?>

                                    <li><i class="bi bi-check-circle-fill list-icon"></i><?php echo htmlspecialchars($type['name']); ?></li>

                                <?php endforeach; ?>

                            </ul>

                        <?php else: ?>

                            <p class="text-muted">No specific care types listed</p>

                        <?php endif; ?>

                    </div>

                </div>

                

                <div class="col-lg-4 col-md-6 mb-4">

                    <div class="info-card">

                        <h3 class="info-card-title">

                            <i class="bi bi-credit-card info-card-icon"></i>Payment Options

                        </h3>

                        <?php if (!empty($payment_options)): ?>

                            <ul>

                                <?php foreach ($payment_options as $option): ?>

                                    <li><i class="bi bi-check-circle-fill list-icon"></i><?php echo htmlspecialchars($option['name']); ?></li>

                                <?php endforeach; ?>

                            </ul>

                        <?php else: ?>

                            <p class="text-muted">No payment options listed</p>

                        <?php endif; ?>

                    </div>

                </div>

                

                <div class="col-lg-4 col-md-6 mb-4">

                    <div class="info-card">

                        <h3 class="info-card-title">

                            <i class="bi bi-info-circle info-card-icon"></i>Additional Information

                        </h3>

                        <ul>

                            <li><i class="bi bi-people-fill list-icon"></i><strong>Gender Accepted:</strong> <?php 

                                $gender = empty($facility['gender_accepted']) ? 'Not Specified' : $facility['gender_accepted'];

                                echo htmlspecialchars((string)$gender); 

                            ?></li>

                            <li><i class="bi bi-person-fill list-icon"></i><strong>Age Range:</strong> <?php 

                                $age_range = empty($facility['age_groups_served']) ? 'Not Specified' : $facility['age_groups_served'];

                                echo htmlspecialchars((string)$age_range); 

                            ?></li>

                        </ul>

                    </div>

                </div>

            </div>

        </div>

            

        <div class="row mb-4">

            <div class="col-md-8">

                <h4 class="facility-info-heading">Service Description</h4>

                <?php if (!empty($facility['long_description'])): ?>

                    <div class="service-description">

                        <?php echo $facility['long_description']; ?>

                    </div>

                <?php else: ?>

                    <p>This facility provides recovery services for individuals seeking support.</p>

                <?php endif; ?>

            </div>

            <div class="col-md-4">

                <div class="social-sharing text-md-end">

                    <h4>Share this Facility</h4>

                    <div class="d-flex justify-content-md-end gap-2">

                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($canonical_url); ?>" 

                           target="_blank" rel="noopener" aria-label="Share on Facebook" class="btn btn-primary">

                            <i class="bi bi-facebook"></i> Facebook

                        </a>

                        

                        <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode($canonical_url); ?>&text=<?php echo urlencode('Check out ' . $facility['name'] . ' on SoberList.org'); ?>" 

                           target="_blank" rel="noopener" aria-label="Share on Twitter" class="btn btn-info">

                            <i class="bi bi-twitter"></i> Twitter

                        </a>

                        

                        <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode($canonical_url); ?>" 

                           target="_blank" rel="noopener" aria-label="Share on LinkedIn" class="btn btn-primary">

                            <i class="bi bi-linkedin"></i> LinkedIn

                        </a>

                    </div>

                </div>

            </div>

        </div>

     

        <hr class="my-5">



        <!-- Advertising container with fixed height to prevent layout shift -->

        <div class="ad-container my-4" data-ad-slot="7823769250" style="min-height:250px;">

            <!-- Ads will be loaded via JavaScript -->

        </div>



        <!-- Reviews Section -->

        <section class="reviews-section mb-5">

            <h2 class="section-title mb-4">

                <i class="bi bi-star-fill text-warning me-2"></i>Google Reviews

            </h2>

            

            <?php

            $pdo = get_db_connection();

            $stmt = $pdo->prepare("SELECT google_reviews, last_reviews_update FROM facilities WHERE id = ?");

            $stmt->execute([$facility['id']]);

            $review_data = $stmt->fetch(PDO::FETCH_ASSOC);

            $reviews = [];

            $last_update = null;

            

            if ($review_data) {

                if (!empty($review_data['google_reviews']) && is_string($review_data['google_reviews'])) {

                    $reviews = json_decode($review_data['google_reviews'], true);

                    if (json_last_error() !== JSON_ERROR_NONE) {

                        error_log("JSON decode error in reviews display: " . json_last_error_msg());

                        $reviews = [];

                    }

                } else {

                    $reviews = [];

                }

                $last_update = isset($review_data['last_reviews_update']) ? $review_data['last_reviews_update'] : null;

            }



            if (!empty($reviews)) {

                $total_reviews = count($reviews);

                $review_sum = 0;

                foreach ($reviews as $review) {

                    $review_sum += isset($review['rating']) ? (float)$review['rating'] : 0;

                }

                $average_rating = $total_reviews > 0 ? $review_sum / $total_reviews : 0;

            ?>

            <div class="review-summary mb-4">

                <div class="d-flex align-items-center">

                    <div class="h1 mb-0 me-3"><?php echo number_format($average_rating, 1); ?></div>

                    <div>

                        <div class="stars">

                            <?php for ($i = 1; $i <= 5; $i++): ?>

                                <?php if ($i <= floor($average_rating)): ?>

                                    <i class="bi bi-star-fill" style="color: gold;"></i>

                                <?php elseif ($i - 0.5 <= $average_rating): ?>

                                    <i class="bi bi-star-half" style="color: gold;"></i>

                                <?php else: ?>

                                    <i class="bi bi-star" style="color: gold;"></i>

                                <?php endif; ?>

                            <?php endfor; ?>

                        </div>

                        <div class="text-muted"><?php echo $total_reviews; ?> <?php echo $total_reviews === 1 ? 'review' : 'reviews'; ?></div>

                    </div>

                </div>

                <?php if (isset($last_update) && $last_update): ?>

                <div class="text-muted small mt-2">Last updated: <?php echo date('F j, Y', strtotime($last_update)); ?></div>

                <?php endif; ?>

            </div>



            <!-- Pre-reserve height for reviews to prevent layout shifts -->

            <div class="reviews-list" style="min-height:300px;">

                <?php 

                // Limit visible reviews initially to 5

                $visible_count = min(count($reviews), 5);

                

                for ($idx = 0; $idx < $visible_count; $idx++): 

                    $review = $reviews[$idx];

                    if (empty($review['author_name'])) continue;

                    

                    // Safe time handling to prevent PHP notices/warnings

                    $reviewDate = '';

                    if (isset($review['time']) && !empty($review['time'])) {

                        if (is_numeric($review['time'])) {

                            $reviewDate = date('F j, Y', (int)$review['time']);

                        } elseif (is_string($review['time'])) {

                            $timestamp = strtotime($review['time']);

                            if ($timestamp !== false) {

                                $reviewDate = date('F j, Y', $timestamp);

                            }

                        }

                    }

                ?>

                    <div class="review card p-3 mb-3 review-card">

                        <div class="d-flex justify-content-between align-items-center mb-2">

                            <div class="d-flex align-items-center">

                                <?php if (!empty($review['profile_photo_url'])): ?>

                                    <img src="<?php echo htmlspecialchars($review['profile_photo_url']); ?>" 

                                         alt="<?php echo htmlspecialchars($review['author_name']); ?>" 

                                         class="review-profile-image me-2" 

                                         width="50" height="50"

                                         loading="lazy">

                                <?php else: ?>

                                    <!-- Placeholder to maintain layout -->

                                    <div class="review-profile-image me-2" style="width:50px;height:50px;background:#f0f0f0;border-radius:50%;"></div>

                                <?php endif; ?>

                                <div>

                                    <strong><?php echo htmlspecialchars($review['author_name']); ?></strong>

                                    <?php if (!empty($reviewDate)): ?>

                                        <div class="text-muted small"><?php echo $reviewDate; ?></div>

                                    <?php endif; ?>

                                </div>

                            </div>

                            <div class="ratings">

                                <?php 

                                $rating = isset($review['rating']) ? (int)$review['rating'] : 0;

                                for ($i = 1; $i <= 5; $i++): 

                                ?>

                                    <i class="bi bi-star<?php echo $i <= $rating ? '-fill' : ''; ?>" 

                                       style="color: <?php echo $i <= $rating ? 'gold' : '#ccc'; ?>;"></i>

                                <?php endfor; ?>

                            </div>

                        </div>

                        <?php if (!empty($review['text'])): ?>

                            <p class="mb-0"><?php echo htmlspecialchars($review['text']); ?></p>

                        <?php endif; ?>

                    </div>

                <?php endfor; ?>

                

                <?php if (count($reviews) > 5): ?>

                <div class="text-center mt-3" id="loadMoreContainer">

                    <button class="btn btn-outline-primary btn-sm" id="loadMoreReviews" type="button">Load More Reviews</button>

                </div>

                <!-- Hidden reviews that will be shown when button is clicked -->

                <div id="hiddenReviews" style="display:none;">

                    <?php 

                    for ($idx = 5; $idx < count($reviews); $idx++): 

                        $review = $reviews[$idx];

                        if (empty($review['author_name'])) continue;

                        

                        // Safe time handling with extra checks for empty values

                        $reviewDate = '';

                        if (isset($review['time']) && !empty($review['time'])) {

                            if (is_numeric($review['time'])) {

                                $reviewDate = date('F j, Y', (int)$review['time']);

                            } elseif (is_string($review['time'])) {

                                $timestamp = strtotime($review['time']);

                                if ($timestamp !== false) {

                                    $reviewDate = date('F j, Y', $timestamp);

                                }

                            }

                        }

                    ?>

                        <div class="review card p-3 mb-3 review-card">

                            <div class="d-flex justify-content-between align-items-center mb-2">

                                <div class="d-flex align-items-center">

                                    <?php if (!empty($review['profile_photo_url'])): ?>

                                        <img src="<?php echo htmlspecialchars($review['profile_photo_url']); ?>" 

                                             alt="<?php echo htmlspecialchars($review['author_name']); ?>" 

                                             class="review-profile-image me-2" 

                                             width="50" height="50"

                                             loading="lazy">

                                    <?php else: ?>

                                        <!-- Placeholder to maintain layout -->

                                        <div class="review-profile-image me-2" style="width:50px;height:50px;background:#f0f0f0;border-radius:50%;"></div>

                                    <?php endif; ?>

                                    <div>

                                        <strong><?php echo htmlspecialchars($review['author_name']); ?></strong>

                                        <?php if (!empty($reviewDate)): ?>

                                            <div class="text-muted small"><?php echo $reviewDate; ?></div>

                                        <?php endif; ?>

                                    </div>

                                </div>

                                <div class="ratings">

                                    <?php 

                                    $rating = isset($review['rating']) ? (int)$review['rating'] : 0;

                                    for ($i = 1; $i <= 5; $i++): 

                                    ?>

                                        <i class="bi bi-star<?php echo $i <= $rating ? '-fill' : ''; ?>" 

                                           style="color: <?php echo $i <= $rating ? 'gold' : '#ccc'; ?>;"></i>

                                    <?php endfor; ?>

                                </div>

                            </div>

                            <?php if (!empty($review['text'])): ?>

                                <p class="mb-0"><?php echo htmlspecialchars($review['text']); ?></p>

                            <?php endif; ?>

                        </div>

                    <?php endfor; ?>

                </div>

                <?php endif; ?>

            </div>

            <?php } else { ?>

            <p class="text-muted py-3">No Google reviews available.</p>

            <?php } ?>

        </section>



        <!-- Second ad container with fixed height -->

        <div class="ad-container my-4" data-ad-slot="3021200410" style="min-height:250px;">

            <!-- Ads will be loaded via JavaScript -->

        </div>



        <?php

        // Include FAQ accordion generator - with custom title and intro

        echo generate_faq_accordion(

            'Your Recovery Journey: Questions Answered',

            'We understand you have questions about addiction recovery. As healthcare professionals dedicated to your wellness, we\'ve compiled answers to common concerns to help guide your path to healing.'

        );

        ?>

    </div> 

</section>



<!-- Similar Facilities Section -->

<section class="similar-facilities py-5 bg-light similar-facilities-section">

    <div class="container">

        <h2 class="section-title mb-4">

            <i class="bi bi-geo-alt text-primary me-2"></i>Nearby Recovery Resources

        </h2>

        

        <?php 

        // First try to use similar facilities if they exist

        $nearby_facilities = $similar_facilities;

        

        // If no similar facilities found, get nearest 3 facilities of any type

        if (empty($nearby_facilities) || count($nearby_facilities) < 3) {

            // Use existing coordinates of the current facility to find nearest ones

            if (!empty($facility['latitude']) && !empty($facility['longitude'])) {

                try {

                    $pdo = get_db_connection();

                    $query = "

                        SELECT f.*, 

                        (3959 * acos(cos(radians(?)) * cos(radians(latitude)) * cos(radians(longitude) - radians(?)) + sin(radians(?)) * sin(radians(latitude)))) AS distance 

                        FROM facilities f 

                        WHERE f.id <> ? 

                        AND f.is_active = 1

                        AND f.latitude IS NOT NULL 

                        AND f.longitude IS NOT NULL 

                        ORDER BY distance ASC

                        LIMIT 3

                    ";

                    

                    $stmt = $pdo->prepare($query);

                    $stmt->execute([

                        $facility['latitude'],$facility['longitude'],

                        $facility['latitude'],

                        $facility['id']

                    ]);

                    

                    $nearest_facilities = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    

                    if (!empty($nearest_facilities)) {

                        $nearby_facilities = $nearest_facilities;

                    }

                } catch (Exception $e) {

                    error_log("Error finding nearby facilities: " . $e->getMessage());

                }

            }

        }

        

        if (!empty($nearby_facilities) && is_array($nearby_facilities) && count($nearby_facilities) > 0): 

        ?>

            <div class="row">

                <?php foreach (array_slice($nearby_facilities, 0, 3) as $similar): ?>

                    <div class="col-lg-4 col-md-6 col-sm-12 mb-4">

                        <div class="card h-100 similar-facility-card">

                            <!-- Fixed height image container to prevent layout shifts -->

                            <div class="similar-facility-image-container">

                                <?php 

                                $similarImageInfo = getFacilityImage($similar, get_facility_care_types($similar['id']));

                                ?>

                                <img src="<?php echo htmlspecialchars($similarImageInfo['path']); ?>" 

                                     alt="<?php echo htmlspecialchars($similarImageInfo['alt']); ?>"

                                     class="similar-facility-image"

                                     width="400" height="400"

                                     loading="lazy">

                            </div>

                            

                            <div class="card-body d-flex flex-column">

                                <h3 class="h5 mb-2">

                                    <a href="/facility/<?php echo get_facility_slug($similar); ?>" class="stretched-link text-decoration-none">

                                        <?php echo htmlspecialchars($similar['name']); ?>

                                    </a>

                                </h3>

                                

                                <p class="text-muted mb-2">

                                    <i class="bi bi-geo-alt me-1"></i>

                                    <?php echo htmlspecialchars($similar['city'] . ', ' . $similar['state_code']); ?>

                                    <?php if (!empty($similar['distance'])): ?>

                                        <span class="ms-1">(<?php echo number_format($similar['distance'], 1); ?> mi)</span>

                                    <?php endif; ?>

                                </p>

                                

                                <?php 

                                $similarCareTypes = get_facility_care_types($similar['id']);

                                if (!empty($similarCareTypes)): 

                                    $typeNames = array_column($similarCareTypes, 'name');

                                ?>

                                    <p class="small text-muted mb-3">

                                        <strong>Care types:</strong> 

                                        <?php echo htmlspecialchars(implode(', ', array_slice($typeNames, 0, 2))); ?>

                                        <?php if (count($typeNames) > 2): ?>

                                            and <?php echo count($typeNames) - 2; ?> more

                                        <?php endif; ?>

                                    </p>

                                <?php endif; ?>

                            </div>

                        </div>

                    </div>

                <?php endforeach; ?>

            </div>

        <?php else: ?>

            <div class="alert alert-info">

                <i class="bi bi-info-circle me-2"></i>No nearby recovery resources found.

            </div>

        <?php endif; ?>

        

        <div class="text-center mt-4">

            <a href="/directory<?php echo !empty($facility['state_code']) ? '?state=' . $facility['state_code'] : ''; ?>" class="btn btn-primary">

                Find More Resources

            </a>

        </div>

    </div>

</section>



<!-- Call to Action Section -->

<section class="cta-section py-4 bg-primary text-white text-center rounded mb-5">

    <div class="container">

        <h2 class="h3 mb-3">Need Help Finding the Right Recovery Resources?</h2>

        <p class="mb-4">Our site can help. We have over 20,000 facilities listed.</p>

        <a href="/" class="btn btn-light btn-lg">Find Out More</a>

    </div>

</section>



<script>

// Add performance monitoring

if ('PerformanceObserver' in window) {

    try {

        // Monitor Largest Contentful Paint

        new PerformanceObserver((entryList) => {

            const entries = entryList.getEntries();

            const lastEntry = entries[entries.length - 1];

            console.log('LCP:', Math.round(lastEntry.startTime), 'Element:', lastEntry.element);

        }).observe({type: 'largest-contentful-paint', buffered: true});

        

        // Monitor Cumulative Layout Shift

        new PerformanceObserver((entryList) => {

            let totalShift = 0;

            for (const entry of entryList.getEntries()) {

                if (!entry.hadRecentInput) {

                    totalShift += entry.value;

                    console.log('Layout shift:', entry.value.toFixed(4), entry.sources || []);

                }

            }

            console.log('Total CLS:', totalShift.toFixed(4));

        }).observe({type: 'layout-shift', buffered: true});

    } catch (e) {

        console.warn('Performance monitoring error:', e);

    }

}



// Wait for DOM to be fully loaded

document.addEventListener('DOMContentLoaded', function() {

    // Prevent Google Ads from causing layout shifts

    const adContainers = document.querySelectorAll('.ad-container');

    adContainers.forEach(container => {

        container.style.display = 'flex';

        container.style.justifyContent = 'center';

        container.style.alignItems = 'center';

        container.innerHTML = '<div style="text-align:center;color:#777;">Advertisement</div>';

    });

    

    // Handle the "Load More Reviews" button

    const loadMoreBtn = document.getElementById('loadMoreReviews');

    const hiddenReviews = document.getElementById('hiddenReviews');

    const loadMoreContainer = document.getElementById('loadMoreContainer');

    

    if (loadMoreBtn && hiddenReviews) {

        loadMoreBtn.addEventListener('click', function() {

            // Get all hidden reviews content and move it to the reviews-list

            const reviewsList = document.querySelector('.reviews-list');

            const content = hiddenReviews.innerHTML;

            

            // First create a container to append content to avoid layout shifts

            const tempContainer = document.createElement('div');

            tempContainer.innerHTML = content;

            tempContainer.style.opacity = '0';

            

            // Add to DOM but invisible

            reviewsList.insertBefore(tempContainer, loadMoreContainer);

            

            // Force reflow

            void tempContainer.offsetHeight;

            

            // Now make visible and remove container

            const fragment = document.createDocumentFragment();

            while (tempContainer.firstChild) {

                fragment.appendChild(tempContainer.firstChild);

            }

            

            reviewsList.insertBefore(fragment, loadMoreContainer);

            

            // Remove the temporary container and hide button container

            tempContainer.remove();

            loadMoreContainer.style.display = 'none';

        });

    }

});

</script>



<?php 

// Include footer

include(BASE_PATH . '/app/Views/components/footer.php'); 

?>