<?php
/**
 * Privacy Policy Page Configuration
 * CleanKitchens.org
 */

// Set page title and meta information
$page_title = "Privacy Policy | CleanKitchens.org";
$meta_description = "Learn about how CleanKitchens.org collects, uses, and protects your personal information. We value your privacy and are committed to transparency.";
$keywords = "privacy policy, data protection, personal information, cookies, GDPR, CCPA";

// Open Graph metadata
$og_title = "Privacy Policy | CleanKitchens.org";
$og_description = "Learn about how CleanKitchens.org collects, uses, and protects your personal information.";
$og_image = "/assets/images/privacy-shield.jpg";
$og_type = "website";

// Schema.org structured data JSON-LD
$schema_json = '{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "https://www.cleankitchens.org/privacy"
  },
  "headline": "Privacy Policy",
  "description": "Learn about how CleanKitchens.org collects, uses, and protects your personal information. We value your privacy and are committed to transparency.",
  "publisher": {
    "@type": "Organization",
    "name": "CleanKitchens.org",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.cleankitchens.org/assets/images/logo.png"
    }
  },
  "datePublished": "2025-03-28",
  "dateModified": "2025-03-28"
}';

// Set breadcrumbs data if needed
$breadcrumbs = [
  [
    'url' => '/',
    'text' => 'Home'
  ],
  [
    'url' => '/privacy',
    'text' => 'Privacy Policy',
    'current' => true
  ]
];