<div class="container">
    <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto" style="min-height:250px;">
            <h1>Access Over 20,000 Recovery Resources Nationwide</h1>
            <p>SoberList provides the nation's most comprehensive directory of recovery resources with over 20,000 verified facilities across all 50 states. Whether you're seeking detox services, inpatient treatment, sober living, or community support meetings, our extensive database connects you with the specific help you need on your recovery journey.</p>
            
            <h2>Types of Recovery Resources</h2>
            <p>Our directory includes various facilities and services tailored to different stages of the recovery process:</p>
            
            <h3>Detox Centers</h3>
            <p>Medically supervised detoxification facilities help individuals safely withdraw from substances under professional care. These centers provide crucial support during the initial phase of recovery, managing withdrawal symptoms and preparing clients for ongoing treatment.</p>
            
            <h3>Treatment Facilities</h3>
            <p>Inpatient and outpatient treatment centers offer structured therapy programs, counseling, and recovery services. These facilities provide varying levels of care, from intensive residential programs to flexible outpatient options, addressing both substance use disorders and co-occurring mental health conditions.</p>
            
            <h3>Sober Living Homes</h3>
            <p>Transitional housing options provide supportive, substance-free environments for individuals in early recovery. Sober living homes bridge the gap between intensive treatment and independent living, offering structure, peer support, and accountability.</p>
            
            <h3>AA/NA Meetings and Support Groups</h3>
            <p>Community-based recovery meetings offer ongoing support, mentorship, and fellowship. These free resources follow various approaches and philosophies, creating accessible support networks for sustainable long-term recovery.</p>
            
            <h2>Finding the Right Resources</h2>
            <p>Recovery needs are highly individualized. Our platform helps you locate resources based on:</p>
            <ul>
                <li>Geographic location - find help close to home or in specific regions</li>
                <li>Specialized services - such as dual diagnosis treatment or gender-specific programs</li>
                <li>Treatment approaches - including 12-step, evidence-based therapies, and holistic options</li>
                <li>Insurance acceptance - facilities that work with your specific coverage</li>
                <li>Availability - resources with current openings for immediate assistance</li>
            </ul>
            
            <h2>Verified and Trusted Information</h2>
            <p>Each facility in our database undergoes verification to ensure accuracy. We provide detailed information about services offered, amenities, treatment approaches, and payment options to help you make informed decisions about your recovery journey.</p>
            
            <div class="cta-box" style="background-color: #f8f9fa; padding: 25px; border-radius: 5px; margin-top: 30px;">
                <h3>Need Help Finding Resources?</h3>
                <p>Use our search tool to find specific facilities in your area, or contact us for personalized assistance in navigating available options.</p>
                <a href="/directory" class="btn btn-primary">Search Resources</a>
            </div>
        </div>
    </div>
</div>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Recovery Resources Directory - SoberList",
  "description": "Access over 20,000 verified recovery resources including detox centers, treatment facilities, sober living homes, and support groups nationwide.",
  "mainEntity": {
    "@type": "ItemList",
    "itemListElement": [
      {
        "@type": "ListItem",
        "position": 1,
        "name": "Detox Centers",
        "description": "Medically supervised facilities for safe withdrawal from substances"
      },
      {
        "@type": "ListItem",
        "position": 2,
        "name": "Treatment Facilities",
        "description": "Inpatient and outpatient centers providing structured recovery programs"
      },
      {
        "@type": "ListItem",
        "position": 3,
        "name": "Sober Living Homes",
        "description": "Transitional housing offering supportive substance-free environments"
      },
      {
        "@type": "ListItem",
        "position": 4,
        "name": "AA/NA Meetings",
        "description": "Community-based support groups for ongoing recovery"
      }
    ]
  },
  "offers": {
    "@type": "Offer",
    "price": "0",
    "priceCurrency": "USD",
    "availability": "https://schema.org/InStock",
    "description": "Free access to search and connect with recovery resources nationwide"
  }
}
</script>